<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $profile    = $profile ?? [];
    $activities = $activities ?? [];
    $education  = $education ?? [];

    $skills    = array_filter(array_map('trim', explode(',', (string) ($profile['skills'] ?? ''))));
    $photoUrl  = '';
    $photoPath = $profile['photo_path'] ?? ($profile['photo'] ?? '');

    if ($photoPath !== '') {
        $relative = ltrim(str_replace(['\\', '/'], '/', $photoPath), '/');
        $fullPath = FCPATH . $relative;

        if (! is_file($fullPath)) {
            $altRelative = 'uploads/' . basename($relative);
            $altFullPath = FCPATH . $altRelative;

            if (is_file($altFullPath)) {
                $relative = $altRelative;
                $fullPath = $altFullPath;
            }
        }

        if (is_file($fullPath)) {
            $photoUrl = base_url($relative) . '?v=' . filemtime($fullPath);
        }
    }

    if ($photoUrl === '' && is_file(FCPATH . 'uploads/profile.jpg')) {
        $photoUrl = base_url('uploads/profile.jpg') . '?v=' . filemtime(FCPATH . 'uploads/profile.jpg');
    }

    $galleryFiles = glob(FCPATH . 'uploads/gallery/*.{jpg,jpeg,png,webp}', GLOB_BRACE) ?: [];
    $gallery      = array_map(static function ($path) {
        return base_url('uploads/gallery/' . basename($path));
    }, $galleryFiles);
?>

<div class="container app-container portfolio-page">
    <section class="portfolio-hero card-surface">
        <div class="portfolio-hero__grid">
            <div class="portfolio-hero__avatar-wrap">
                <div class="portfolio-avatar fade-in-on-scroll">
                    <?php if (! empty($photoUrl)): ?>
                        <img src="<?= esc($photoUrl) ?>" alt="Foto profil <?= esc($profile['full_name'] ?? 'Pengguna') ?>" loading="lazy">
                    <?php else: ?>
                        <div class="portfolio-avatar__placeholder">
                            <?= esc(strtoupper(substr($profile['full_name'] ?? 'DR', 0, 2))) ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="portfolio-hero__badge">Portofolio · CV</div>
            </div>

            <div class="portfolio-hero__info">
                <div class="portfolio-hero__title">
                    <h1><?= esc($profile['full_name'] ?? 'Nama belum diisi') ?></h1>
                    <p><?= esc($profile['headline'] ?? 'Lengkapi headline Anda') ?></p>
                </div>
                <div class="portfolio-hero__meta">
                    <?php if (! empty($profile['email'])): ?>
                        <div class="contact-card">
                            <span class="meta-label">Email</span>
                            <div class="meta-value"><?= esc($profile['email']) ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if (! empty($profile['phone'])): ?>
                        <div class="contact-card">
                            <span class="meta-label">Telepon</span>
                            <div class="meta-value"><?= esc($profile['phone']) ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if (! empty($profile['address'])): ?>
                        <div class="contact-card contact-card--wide">
                            <span class="meta-label">Alamat</span>
                            <div class="meta-value"><?= esc($profile['address']) ?></div>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if (! empty($skills)): ?>
                    <div class="portfolio-hero__skills">
                        <?php foreach ($skills as $skill): ?>
                            <span class="pill"><?= esc($skill) ?></span>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

            <div class="portfolio-hero__cta-col">
                <a class="btn btn-primary btn-soft" href="<?= base_url('cv') ?>">Lihat Biodata Detail</a>
                <a class="btn btn-outline-primary btn-soft" href="<?= base_url('aktivitas') ?>">Aktivitas Harian</a>
            </div>
        </div>
    </section>

    <?php if (! empty($gallery)): ?>
        <section class="card-surface gallery-section fade-in-on-scroll" id="gallery">
            <div class="card-header-flex gallery-header">
                <div>
                    <p class="section-eyebrow">Galeri</p>
                    <h2 class="section-title">Memories</h2>
                </div>
            </div>
            <div class="gallery-grid">
                <?php foreach ($gallery as $index => $src): ?>
                    <button
                        class="gallery-card"
                        type="button"
                        data-bs-toggle="modal"
                        data-bs-target="#galleryModal"
                        data-src="<?= esc($src) ?>"
                        data-index="<?= $index ?>"
                        data-category="kegiatan">
                        <img src="<?= esc($src) ?>" alt="Foto galeri" loading="lazy">
                        <span class="gallery-overlay">Lihat</span>
                    </button>
                <?php endforeach; ?>
            </div>
        </section>

        <div class="modal fade" id="galleryModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content modal-dark">
                    <div class="modal-body p-0 position-relative">
                        <img id="galleryModalImage" src="" alt="Foto galeri" class="w-100" style="border-radius: 12px;">
                        <button type="button" class="gallery-nav gallery-nav--prev" aria-label="Foto sebelumnya">‹</button>
                        <button type="button" class="gallery-nav gallery-nav--next" aria-label="Foto selanjutnya">›</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="row g-4 mt-4">
        <div class="col-lg-6">
            <section class="card-surface card-timeline">
                <div class="card-header-flex">
                    <div>
                        <p class="section-eyebrow">Aktivitas Harian</p>
                        <h2 class="section-title">Log Kegiatan Terbaru</h2>
                    </div>
                    <a class="link-primary" href="<?= base_url('aktivitas') ?>">Lihat semua</a>
                </div>
                <?php if (empty($activities)): ?>
                    <div class="empty-state">Belum ada aktivitas.</div>
                <?php else: ?>
                    <ul class="timeline">
                        <?php foreach ($activities as $item): ?>
                            <?php
                                $date = $item['activity_date'] ?? null;
                                $time = $item['activity_time'] ?? null;
                                $formattedDate = $date ? date('d M Y', strtotime($date)) : '-';
                                $formattedTime = $time ? date('H:i', strtotime($time)) : '';
                            ?>
                            <li class="timeline__item">
                                <div class="timeline__point"></div>
                                <div class="timeline__body">
                                    <div class="timeline__meta">
                                        <span><?= esc($formattedDate) ?></span>
                                        <?php if ($formattedTime): ?>
                                            <span><?= esc($formattedTime) ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <h3><?= esc($item['title'] ?? 'Aktivitas') ?></h3>
                                    <?php if (! empty($item['location'])): ?>
                                        <div class="timeline__badge"><?= esc($item['location']) ?></div>
                                    <?php endif; ?>
                                    <p><?= esc(mb_strimwidth(strip_tags((string) ($item['description'] ?? '')), 0, 140, '...')) ?></p>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </section>
        </div>
        <div class="col-lg-6">
            <section class="card-surface card-timeline">
                <div class="card-header-flex">
                    <div>
                        <p class="section-eyebrow">Riwayat Pendidikan</p>
                        <h2 class="section-title">Perjalanan Akademik</h2>
                    </div>
                    <a class="link-primary" href="<?= base_url('pendidikan') ?>">Lihat semua</a>
                </div>
                <?php if (empty($education)): ?>
                    <div class="empty-state">Belum ada data pendidikan.</div>
                <?php else: ?>
                    <ul class="timeline timeline--alt">
                        <?php foreach ($education as $edu): ?>
                            <?php
                                $period = ($edu['start_year'] ?? '') . ' - ' . (($edu['end_year'] ?? '') ?: 'Sekarang');
                            ?>
                            <li class="timeline__item">
                                <div class="timeline__point"></div>
                                <div class="timeline__body">
                                    <div class="timeline__meta">
                                        <span><?= esc($edu['degree'] ?? '-') ?></span>
                                        <span><?= esc($period) ?></span>
                                    </div>
                                    <h3><?= esc($edu['institution'] ?? '-') ?></h3>
                                    <?php if (! empty($edu['field_of_study'])): ?>
                                        <div class="timeline__badge"><?= esc($edu['field_of_study']) ?></div>
                                    <?php endif; ?>
                                    <?php if (! empty($edu['description'])): ?>
                                        <p><?= esc(mb_strimwidth(strip_tags((string) $edu['description']), 0, 140, '...')) ?></p>
                                    <?php endif; ?>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </section>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
