<?php
    $recentNews = $recentNews ?? [];
    $limit = $limit ?? 6;

    $formatDate = static function (?string $date): string {
        if (empty($date)) {
            return 'Tanggal tidak diketahui';
        }
        $timestamp = strtotime($date);
        if ($timestamp === false) {
            return $date;
        }
        $months = [
            1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr',
            5 => 'Mei', 6 => 'Jun', 7 => 'Jul', 8 => 'Agu',
            9 => 'Sep', 10 => 'Okt', 11 => 'Nov', 12 => 'Des',
        ];
        return date('d', $timestamp) . ' ' . ($months[(int) date('n', $timestamp)] ?? date('M', $timestamp)) . ' ' . date('Y', $timestamp);
    };

    $estimateReadingTime = static function (?string $content): int {
        if (empty($content)) {
            return 1;
        }
        $wordCount = str_word_count(strip_tags($content));
        $minutes = max(1, (int) ceil($wordCount / 190));
        return $minutes;
    };

    $getImageUrl = static function (?string $imagePath): string {
        if (empty($imagePath)) {
            return 'https://images.unsplash.com/photo-1487058792275-0ad4aaf24ca7?auto=format&fit=crop&w=400&q=80';
        }
        return base_url($imagePath);
    };
?>
<div class="sidebar-card">
    <div class="sidebar-card__title">Postingan Terbaru</div>
    <?php if (empty($recentNews)): ?>
        <div class="text-muted text-center py-4 small">
            Belum ada postingan terbaru.
        </div>
    <?php else: ?>
        <ul class="sidebar-list">
            <?php foreach ($recentNews as $news): ?>
                <?php
                    $title = esc($news['title'] ?? 'Judul tidak tersedia');
                    $slug = $news['slug'] ?? '';
                    $createdAt = $news['created_at'] ?? null;
                    $formattedDate = $formatDate($createdAt);
                    $readingTime = $estimateReadingTime($news['content'] ?? '');
                    $imageUrl = $getImageUrl($news['image_path'] ?? null);
                    $newsUrl = ! empty($slug) ? base_url('news/' . $slug) : '#';
                ?>
                <li class="sidebar-list__item">
                    <a href="<?= $newsUrl ?>">
                        <div class="sidebar-list__thumb">
                            <img src="<?= $imageUrl ?>" alt="<?= $title ?>" loading="lazy">
                        </div>
                        <div>
                            <div class="sidebar-list__title"><?= $title ?></div>
                            <div class="sidebar-list__meta"><?= $formattedDate ?> · baca <?= $readingTime ?> menit</div>
                        </div>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>