<?= $this->extend('layout/template'); ?>

<?= $this->section('content'); ?>

<div class="row justify-content-center">
    <!-- Header -->
    <div class="col-lg-10 text-center mb-5 fade-in-up">
        <span class="badge bg-secondary bg-opacity-10 text-secondary rounded-pill px-3 py-2 border border-secondary border-opacity-25 mb-3">My Updates</span>
        <h1 class="fw-bold display-5 mb-3">Aktivitas & <span class="text-gradient">Portfolio</span></h1>
        <p class="text-muted lead mx-auto" style="max-width: 600px;">
            Jurnal kegiatan harian, proyek yang sedang dikerjakan, dan pencapaian terbaru.
        </p>
    </div>

    <div class="col-lg-10">
        <!-- Search Bar -->
        <div class="card glass rounded-pill mb-5 border-0 fade-in-up delay-100 p-2 shadow-sm">
            <div class="card-body p-1">
                 <form action="<?= base_url('/aktivitas'); ?>" method="get" class="d-flex flex-column flex-md-row gap-2">
                    <div class="input-group flex-grow-1">
                        <span class="input-group-text bg-transparent border-0 ps-3"><i class="bi bi-search text-muted"></i></span>
                        <input type="text" class="form-control border-0 bg-transparent shadow-none" name="keyword" placeholder="Cari aktivitas atau proyek..." value="<?= esc($keyword); ?>">
                    </div>
                     <select class="form-select border-0 bg-light rounded-pill" style="min-width: 150px;" name="order">
                        <option value="DESC" <?= $order == 'DESC' ? 'selected' : ''; ?>>Terbaru</option>
                        <option value="ASC" <?= $order == 'ASC' ? 'selected' : ''; ?>>Terlama</option>
                    </select>
                     <button type="submit" class="btn btn-secondary rounded-pill px-4"  style="background-color: var(--secondary-color); border-color: var(--secondary-color);"><i class="bi bi-search"></i></button>
                 </form>
            </div>
        </div>

        <!-- Content Grid -->
        <div class="fade-in-up delay-200">
             <?php if(empty($aktivitas)): ?>
                  <div class="text-center py-5 glass rounded-4 border-0">
                    <div class="mb-3">
                         <i class="bi bi-clipboard-x fs-1 text-muted opacity-50"></i>
                    </div>
                    <h5 class="text-muted">Belum ada aktivitas tercatat.</h5>
                    <a href="<?= base_url('/aktivitas'); ?>" class="btn btn-link text-decoration-none">Lihat Semua</a>
                </div>
            <?php else: ?>
                <div class="row g-4">
                    <?php foreach($aktivitas as $act): ?>
                        <div class="col-md-6">
                            <div class="card glass border-0 h-100 hover-card rounded-4 overflow-hidden d-flex flex-column">
                                <div class="card-body p-4 flex-grow-1">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <div class="badge bg-light text-secondary border rounded-pill px-3 py-2">
                                            <i class="bi bi-calendar2-week me-2"></i> <?= date('d F Y', strtotime($act['tanggal'])); ?>
                                        </div>
                                        <!-- Optional: Add category or status badge here if available -->
                                    </div>
                                    
                                    <h4 class="fw-bold mb-3"><?= esc($act['nama_aktivitas']); ?></h4>
                                    <p class="text-muted mb-4 line-clamp-3">
                                        <?= nl2br(esc($act['keterangan'])); ?>
                                    </p>
                                </div>
                                <div class="card-footer bg-transparent border-0 p-4 pt-0">
                                    <button class="btn btn-outline-secondary rounded-pill btn-sm w-100" data-bs-toggle="modal" data-bs-target="#modalAktivitas<?= $act['id']; ?>">
                                        Lihat Detail <i class="bi bi-arrow-right ms-1"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Detail -->
                        <div class="modal fade" id="modalAktivitas<?= $act['id']; ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content glass border-0 rounded-4">
                                    <div class="modal-header border-0 pb-0">
                                        <h5 class="modal-title fw-bold">Detail Aktivitas</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body p-4">
                                         <div class="badge bg-secondary bg-opacity-10 text-secondary mb-3">
                                            <?= date('l, d F Y', strtotime($act['tanggal'])); ?>
                                        </div>
                                        <h3 class="fw-bold mb-3 text-gradient"><?= esc($act['nama_aktivitas']); ?></h3>
                                        <p class="text-muted"><?= nl2br(esc($act['keterangan'])); ?></p>
                                    </div>
                                     <div class="modal-footer border-0 pt-0">
                                        <button type="button" class="btn btn-light rounded-pill px-4" data-bs-dismiss="modal">Tutup</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="mt-5 d-flex justify-content-center">
                    <?= $pager->links('aktivitas', 'default_full'); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>
