<?= $this->extend('layout/template'); ?>

<?= $this->section('content'); ?>

<!-- Bento Grid Hero Section -->
<div class="bento-grid-container fade-in-up">
    
    <!-- Main Profile Card -->
    <div class="bento-card bento-profile glass">
        <div class="position-relative">
            <?php if(!empty($biodata['foto'])): ?>
                <img src="<?= base_url('uploads/biodata/' . $biodata['foto']); ?>" class="bento-profile-img" alt="Profile">
            <?php else: ?>
                <img src="https://ui-avatars.com/api/?name=<?= urlencode($biodata['nama'] ?? 'User'); ?>&size=512&background=4f46e5&color=fff&bold=true" class="bento-profile-img" alt="Profile">
            <?php endif; ?>
            <div class="profile-glow"></div>
        </div>
        
        <?php if($biodata): ?>
            <h2 class="mt-4 mb-2 fw-bold"><?= esc($biodata['nama']); ?></h2>
            <p class="text-gradient fw-semibold mb-3">Web Developer & Designer</p>
            
            <div class="social-links-compact">
                <?php if(!empty($biodata['link_github'])): ?>
                    <a href="<?= $biodata['link_github']; ?>" class="social-btn" title="GitHub"><i class="bi bi-github"></i></a>
                <?php endif; ?>
                <?php if(!empty($biodata['link_linkedin'])): ?>
                    <a href="<?= $biodata['link_linkedin']; ?>" class="social-btn" title="LinkedIn"><i class="bi bi-linkedin"></i></a>
                <?php endif; ?>
                <?php if(!empty($biodata['link_instagram'])): ?>
                    <a href="<?= $biodata['link_instagram']; ?>" class="social-btn" title="Instagram"><i class="bi bi-instagram"></i></a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- About Card -->
    <div class="bento-card bento-about glass">
        <div class="bento-card-header">
            <i class="bi bi-person-lines-fill text-primary"></i>
            <h5 class="mb-0 fw-bold">About Me</h5>
        </div>
        <?php if($biodata): ?>
            <p class="text-secondary mb-0" style="line-height: 1.7;">
                <?= nl2br(esc($biodata['riwayat_singkat'])); ?>
            </p>
        <?php endif; ?>
    </div>

    <!-- Stats Card 1 -->
    <div class="bento-card bento-stat glass stat-blue">
        <div class="stat-icon"><i class="bi bi-calendar-check"></i></div>
        <h3 class="stat-number">3+</h3>
        <p class="stat-label">Years Experience</p>
    </div>

    <!-- Stats Card 2 -->
    <div class="bento-card bento-stat glass stat-purple">
        <div class="stat-icon"><i class="bi bi-grid-3x3-gap"></i></div>
        <h3 class="stat-number">15+</h3>
        <p class="stat-label">Projects Done</p>
    </div>

    <!-- Stats Card 3 -->
    <div class="bento-card bento-stat glass stat-green">
        <div class="stat-icon"><i class="bi bi-emoji-smile"></i></div>
        <h3 class="stat-number">98%</h3>
        <p class="stat-label">Happy Clients</p>
    </div>

    <!-- Contact Card -->
    <div class="bento-card bento-contact glass">
        <div class="bento-card-header">
            <i class="bi bi-envelope-fill text-primary"></i>
            <h5 class="mb-0 fw-bold">Get In Touch</h5>
        </div>
        
        <?php if($biodata): ?>
            <div class="contact-item">
                <i class="bi bi-envelope"></i>
                <div>
                    <small class="text-muted d-block">Email</small>
                    <span class="fw-medium"><?= esc($biodata['email']); ?></span>
                </div>
            </div>
            
            <div class="contact-item">
                <i class="bi bi-telephone"></i>
                <div>
                    <small class="text-muted d-block">Phone</small>
                    <span class="fw-medium"><?= esc($biodata['no_hp']); ?></span>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Skills/Tech Card -->
    <div class="bento-card bento-skills glass">
        <div class="bento-card-header mb-3">
            <i class="bi bi-code-slash text-primary"></i>
            <h5 class="mb-0 fw-bold">Tech Stack</h5>
        </div>
        
        <div class="skills-grid">
            <span class="skill-tag">PHP</span>
            <span class="skill-tag">CodeIgniter</span>
            <span class="skill-tag">JavaScript</span>
            <span class="skill-tag">Bootstrap</span>
            <span class="skill-tag">MySQL</span>
            <span class="skill-tag">HTML/CSS</span>
        </div>
    </div>

    <!-- CTA Card -->
    <div class="bento-card bento-cta glass">
        <div class="cta-content">
            <h4 class="fw-bold mb-3">Ready to explore?</h4>
            <p class="text-secondary mb-4">Discover my journey and experiences</p>
            
            <!-- <div class="d-flex flex-column gap-2"> -->
                <!-- <a href="<?= base_url('uploads/cv/cv.pdf'); ?>" class="btn btn-primary rounded-pill fw-bold"> -->
                    <!-- <i class="bi bi-download me-2"></i>Download CV -->
                <!-- </a> -->
                <a href="<?= base_url('/pendidikan'); ?>" class="btn btn-outline-primary rounded-pill fw-bold">
                    <i class="bi bi-arrow-right me-2"></i>View Journey
                </a>
            </div>
        </div>
    </div>

</div>

<?= $this->endSection(); ?>
