# Setup Sistem Login Admin

Dokumentasi lengkap untuk mengatur sistem login admin di website CodeIgniter 4.

## 📋 Fitur yang Dibuat

### 1. **Sistem Autentikasi Admin**
- Login dengan username/email dan password
- Session management yang aman
- Remember me functionality
- Auto-logout untuk keamanan
- Password hashing dengan PHP password_hash()

### 2. **Database & Model**
- Tabel `admins` dengan struktur lengkap
- Model `AdminModel` dengan validasi
- Migration dan seeder untuk setup awal
- Support untuk multiple admin roles (super_admin, admin)

### 3. **Controllers**
- `Admin\Auth` - Handle login/logout
- `Admin\Dashboard` - Dashboard dan profile admin
- Filter `AdminAuth` - Proteksi halaman admin

### 4. **Views & UI**
- Halaman login yang responsive dan modern
- Dashboard admin dengan sidebar navigation
- Layout admin yang konsisten
- Bootstrap 5 + Font Awesome icons

### 5. **Security Features**
- CSRF protection
- Session-based authentication
- Password verification
- Admin status checking
- Remember me dengan cookie encryption

## 🚀 Cara Setup

### 1. **Konfigurasi Database**
Edit file `app/Config/Database.php` dan atur koneksi database:

```php
public array $default = [
    'hostname' => 'localhost',
    'username' => 'your_db_username',
    'password' => 'your_db_password', 
    'database' => 'your_database_name',
    'DBDriver' => 'MySQLi',
    // ... konfigurasi lainnya
];
```

### 2. **Jalankan Migration & Seeder**
Buka terminal/command prompt di root project dan jalankan:

```bash
# Jalankan migration untuk membuat tabel admins
php spark migrate

# Jalankan seeder untuk membuat admin default
php spark db:seed AdminSeeder
```

**Atau gunakan script setup otomatis:**
```bash
php setup_admin.php
```

### 3. **Akses Admin Panel**
Setelah setup selesai, akses admin panel di:
```
http://your-domain.com/admin/login
```

**Login Default:**
- Username: `admin`
- Password: `admin123`
- Email: `admin@example.com`

## 📁 Struktur File yang Dibuat

```
app/
├── Controllers/
│   └── Admin/
│       ├── Auth.php          # Controller autentikasi
│       └── Dashboard.php     # Controller dashboard
├── Database/
│   ├── Migrations/
│   │   └── 2024-12-27-000001_CreateAdminsTable.php
│   └── Seeds/
│       └── AdminSeeder.php   # Data admin default
├── Filters/
│   └── AdminAuth.php         # Filter proteksi admin
├── Models/
│   └── AdminModel.php        # Model untuk tabel admins
└── Views/
    └── admin/
        ├── auth/
        │   └── login.php     # Halaman login
        ├── dashboard/
        │   ├── index.php     # Dashboard utama
        │   └── profile.php   # Profile admin
        └── layouts/
            └── main.php      # Layout admin

Config/
├── Filters.php               # Registrasi filter AdminAuth
└── Routes.php                # Routes untuk admin

setup_admin.php               # Script setup otomatis
```

## 🔐 Keamanan

### 1. **Password Security**
- Password di-hash menggunakan `password_hash()` dengan `PASSWORD_DEFAULT`
- Minimum 6 karakter untuk password
- Verifikasi password menggunakan `password_verify()`

### 2. **Session Management**
- Session data admin tersimpan aman
- Auto-destroy session saat logout
- Check admin status di setiap request

### 3. **Access Control**
- Filter `AdminAuth` melindungi semua halaman admin
- Redirect otomatis ke login jika belum login
- Remember me dengan cookie terenkripsi

### 4. **CSRF Protection**
- Semua form menggunakan `csrf_field()`
- Validasi CSRF token otomatis

## 🎨 Customization

### 1. **Mengubah Tampilan**
Edit file di `app/Views/admin/` untuk mengubah tampilan:
- `layouts/main.php` - Layout utama
- `auth/login.php` - Halaman login
- `dashboard/index.php` - Dashboard

### 2. **Menambah Admin Baru**
```php
$adminModel = new AdminModel();
$adminModel->createAdmin([
    'username' => 'newadmin',
    'email' => 'newadmin@example.com',
    'password' => 'password123',
    'full_name' => 'New Administrator',
    'role' => 'admin'
]);
```

### 3. **Mengubah Role Admin**
Edit enum di migration atau tambahkan role baru:
```php
'role' => [
    'type' => 'ENUM',
    'constraint' => ['super_admin', 'admin', 'moderator'],
    'default' => 'admin',
],
```

## 🔧 Troubleshooting

### 1. **Error Database Connection**
- Pastikan database sudah dibuat
- Check konfigurasi di `app/Config/Database.php`
- Pastikan MySQL/database server berjalan

### 2. **Migration Error**
```bash
# Reset migration jika ada error
php spark migrate:rollback
php spark migrate
```

### 3. **Session Issues**
- Pastikan folder `writable/session` ada dan writable
- Check konfigurasi session di `app/Config/Session.php`

### 4. **Route Not Found**
- Pastikan routes sudah ditambahkan di `app/Config/Routes.php`
- Clear route cache: `php spark cache:clear`

## 📱 Responsive Design

Dashboard admin sudah responsive dan mobile-friendly:
- Sidebar collapse di mobile
- Touch-friendly navigation
- Bootstrap 5 responsive grid
- Mobile-optimized forms

## 🔄 Update & Maintenance

### 1. **Update Password Admin**
```php
$adminModel = new AdminModel();
$adminModel->updateAdmin($adminId, [
    'password' => 'newpassword123'
]);
```

### 2. **Backup Database**
```bash
# Backup tabel admins
mysqldump -u username -p database_name admins > admins_backup.sql
```

### 3. **Monitor Login Activity**
Tabel admins menyimpan `last_login` untuk monitoring aktivitas admin.

## 📞 Support

Jika ada pertanyaan atau masalah:
1. Check dokumentasi CodeIgniter 4
2. Periksa log error di `writable/logs/`
3. Pastikan semua file sudah ter-upload dengan benar
4. Check permission folder `writable/`

---

**Selamat! Sistem login admin sudah siap digunakan.** 🎉