# 🚀 Quick Start - Admin Login System

## Setup Cepat (5 Menit)

### 1. **Konfigurasi Database**
Edit `app/Config/Database.php`:
```php
'hostname' => 'localhost',
'username' => 'your_db_user',
'password' => 'your_db_pass',
'database' => 'your_db_name',
```

### 2. **Jalankan Setup**
**Windows:**
```bash
run_admin_setup.bat
```

**Linux/Mac:**
```bash
php spark migrate
php spark db:seed AdminSeeder
```

### 3. **Login Admin**
Akses: `http://localhost/your-project/admin/login`

**Default Login:**
- Username: `admin`
- Password: `admin123`

## ✅ Fitur yang Sudah Siap

- ✅ Login/Logout Admin
- ✅ Dashboard Admin
- ✅ Session Management
- ✅ Remember Me
- ✅ Role-based Access (Super Admin/Admin)
- ✅ Admin Management (untuk Super Admin)
- ✅ Responsive Design
- ✅ Security Features (CSRF, Password Hash)

## 🔧 Customization

### Ubah Default Admin
Edit `app/Database/Seeds/AdminSeeder.php` sebelum menjalankan seeder.

### Tambah Role Baru
Edit migration `CreateAdminsTable.php` dan helper `admin_helper.php`.

### Ubah Tampilan
Edit file di `app/Views/admin/`.

---
**Sistem admin siap digunakan!** 🎉