<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->get('about', 'Page::about');
$routes->get('contact', 'Page::contact');
$routes->get('faqs', 'Page::faqs');

// Frontend routes
$routes->get('activities', 'Activities::index');
$routes->get('biodata', 'Biodata::index');
$routes->get('education', 'Education::index');
$routes->get('admin-access', 'AdminAccess::index');

// Test upload route
$routes->get('test-upload', 'TestUpload::index');
$routes->post('test-upload/upload', 'TestUpload::upload');

// Admin Authentication Routes (no filter)
$routes->group('admin', function($routes){
    $routes->get('login', 'Admin\Auth::login');
    $routes->post('login', 'Admin\Auth::processLogin');
    $routes->get('logout', 'Admin\Auth::logout');
    $routes->get('auth/check-remember', 'Admin\Auth::checkRememberMe');
});

// Protected Admin Routes (with adminauth filter)
$routes->group('admin', ['filter' => 'adminauth'], function($routes){
    // Dashboard
    $routes->get('dashboard', 'Admin\Dashboard::index');
    
    // Profile Management
    $routes->get('profile', 'Admin\ProfileManagement::index');
    $routes->get('profile/(:num)/edit', 'Admin\ProfileManagement::edit/$1');
    $routes->post('profile/(:num)/update', 'Admin\ProfileManagement::update/$1');
    $routes->get('profile/(:num)/delete-photo', 'Admin\ProfileManagement::deletePhoto/$1');
    
    // Admin Management (Super Admin only)
    $routes->get('management', 'Admin\AdminManagement::index');
    $routes->get('management/create', 'Admin\AdminManagement::create');
    $routes->post('management/store', 'Admin\AdminManagement::store');
    $routes->get('management/(:num)/edit', 'Admin\AdminManagement::edit/$1');
    $routes->post('management/(:num)/update', 'Admin\AdminManagement::update/$1');
    $routes->get('management/(:num)/delete', 'Admin\AdminManagement::delete/$1');
    $routes->get('management/(:num)/toggle-status', 'Admin\AdminManagement::toggleStatus/$1');
    
	// Redirect admin root to dashboard
	$routes->get('/', 'Admin\Dashboard::index');
	
	// Admin routes for Activities
	$routes->get('activities', 'Admin\ActivitiesAdmin::index');
	$routes->get('activities/([0-9]+)/preview', 'Admin\ActivitiesAdmin::preview/$1');
	$routes->get('activities/create', 'Admin\ActivitiesAdmin::create');
	$routes->post('activities/create', 'Admin\ActivitiesAdmin::create');
	$routes->get('activities/([0-9]+)/edit', 'Admin\ActivitiesAdmin::edit/$1');
	$routes->post('activities/([0-9]+)/edit', 'Admin\ActivitiesAdmin::edit/$1');
	$routes->get('activities/([0-9]+)/delete', 'Admin\ActivitiesAdmin::delete/$1');
	
	// Admin routes for Biodata
	$routes->get('biodata', 'Admin\BiodataAdmin::index');
	$routes->get('biodata/([0-9]+)/preview', 'Admin\BiodataAdmin::preview/$1');
	$routes->get('biodata/create', 'Admin\BiodataAdmin::create');
	$routes->post('biodata/create', 'Admin\BiodataAdmin::create');
	$routes->get('biodata/edit/([0-9]+)', 'Admin\BiodataAdmin::edit/$1');
	$routes->post('biodata/edit/([0-9]+)', 'Admin\BiodataAdmin::edit/$1');
	$routes->get('biodata/([0-9]+)/delete', 'Admin\BiodataAdmin::delete/$1');
	
	// Admin routes for Education
	$routes->get('education', 'Admin\EducationAdmin::index');
	$routes->get('education/([0-9]+)/preview', 'Admin\EducationAdmin::preview/$1');
	$routes->get('education/create', 'Admin\EducationAdmin::create');
	$routes->post('education/create', 'Admin\EducationAdmin::create');
	$routes->get('education/edit/([0-9]+)', 'Admin\EducationAdmin::edit/$1');
	$routes->post('education/edit/([0-9]+)', 'Admin\EducationAdmin::edit/$1');
	$routes->get('education/([0-9]+)/delete', 'Admin\EducationAdmin::delete/$1');
});
