<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;

class Dashboard extends BaseController
{
    protected $session;

    public function __construct()
    {
        $this->session = \Config\Services::session();
    }

    /**
     * Admin dashboard
     */
    public function index()
    {
        $data = [
            'title' => 'Dashboard Admin',
            'admin' => [
                'id' => $this->session->get('admin_id'),
                'username' => $this->session->get('admin_username'),
                'email' => $this->session->get('admin_email'),
                'full_name' => $this->session->get('admin_full_name'),
                'role' => $this->session->get('admin_role')
            ]
        ];

        return view('admin/dashboard/index', $data);
    }
}