<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ProfileSeeder extends Seeder
{
    public function run()
    {
        $data = [
            'name'        => 'Dodi Iskandar',
            'title'       => 'Web Developer & Student',
            'description' => 'Seorang mahasiswa yang passionate dalam bidang teknologi dan pengembangan web. Selalu bersemangat untuk belajar hal-hal baru dan mengembangkan keterampilan programming.',
            'photo'       => null, // Will be uploaded via admin
            'email'       => 'dodi.iskandar@example.com',
            'phone'       => '+62 812-3456-7890',
            'address'     => 'Jakarta, Indonesia',
            'social_media' => json_encode([
                'instagram' => '@dodi_iskandar',
                'linkedin'  => 'dodi-iskandar',
                'github'    => 'dodiiskandar',
                'twitter'   => '@dodiiskandar'
            ]),
            'is_active'   => 1,
            'created_at'  => date('Y-m-d H:i:s'),
            'updated_at'  => date('Y-m-d H:i:s'),
        ];

        $this->db->table('profile')->insert($data);
    }
}