<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Kelola Aktivitas</h1>
        <p class="text-muted">Manajemen data aktivitas dan kegiatan</p>
    </div>
    <a href="<?= base_url('admin/activities/create') ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>
        Tambah Aktivitas
    </a>
</div>

<!-- Search and Filter -->
<div class="card mb-4">
    <div class="card-body">
        <form method="get" action="<?= base_url('admin/activities') ?>">
            <div class="row">
                <div class="col-md-4 mb-2">
                    <input type="text" name="search" class="form-control" placeholder="Cari nama aktivitas..." value="<?= esc($search) ?>">
                </div>
                <div class="col-md-3 mb-2">
                    <input type="date" name="filter_tanggal" class="form-control" value="<?= esc($filter_tanggal) ?>">
                </div>
                <div class="col-md-2 mb-2">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search me-1"></i>
                        Cari
                    </button>
                </div>
                <div class="col-md-2 mb-2">
                    <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary w-100">
                        <i class="fas fa-refresh me-1"></i>
                        Reset
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Sorting Links -->
<div class="mb-3">
    <small class="text-muted"><strong>Urutkan berdasarkan:</strong></small>
    <div class="btn-group btn-group-sm ms-2">
        <a href="<?= base_url('admin/activities?sort_by=nama_aktivitas&sort_order=' . ($sort_by == 'nama_aktivitas' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>" 
           class="btn btn-outline-secondary">
            Nama Aktivitas <?= $sort_by == 'nama_aktivitas' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/activities?sort_by=tanggal&sort_order=' . ($sort_by == 'tanggal' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>" 
           class="btn btn-outline-secondary">
            Tanggal <?= $sort_by == 'tanggal' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/activities?sort_by=jam&sort_order=' . ($sort_by == 'jam' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>" 
           class="btn btn-outline-secondary">
            Jam <?= $sort_by == 'jam' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<!-- Data Table -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Media</th>
                        <th>Nama Aktivitas</th>
                        <th>Tanggal</th>
                        <th>Jam</th>
                        <th>Deskripsi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($activities)): ?>
                        <tr>
                            <td colspan="7" class="text-center py-4">
                                <i class="fas fa-calendar-alt fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada data aktivitas</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach($activities as $activity): ?>
                        <tr>
                            <td><?= $activity['id'] ?></td>
                            <td>
                                <?php if (!empty($activity['foto'])): ?>
                                    <img src="<?= base_url($activity['foto']) ?>" 
                                         class="rounded" 
                                         style="width: 60px; height: 40px; object-fit: cover;" 
                                         alt="Foto">
                                <?php elseif (!empty($activity['video'])): ?>
                                    <div class="media-preview">
                                        <i class="fas fa-video fa-2x text-primary"></i>
                                        <small class="d-block text-muted">Video</small>
                                    </div>
                                <?php else: ?>
                                    <div class="text-center text-muted">
                                        <i class="fas fa-image"></i>
                                        <small class="d-block">No Media</small>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?= esc($activity['nama_aktivitas']) ?></strong>
                            </td>
                            <td>
                                <span class="badge bg-info">
                                    <?= date('d/m/Y', strtotime($activity['tanggal'])) ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge bg-secondary">
                                    <?= date('H:i', strtotime($activity['jam'])) ?>
                                </span>
                            </td>
                            <td>
                                <?php if (!empty($activity['deskripsi'])): ?>
                                    <?= esc(substr($activity['deskripsi'], 0, 80)) ?>
                                    <?= strlen($activity['deskripsi']) > 80 ? '...' : '' ?>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?= base_url('admin/activities/'.$activity['id'].'/preview') ?>" 
                                       class="btn btn-outline-info" title="Preview" target="_blank">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?= base_url('admin/activities/'.$activity['id'].'/edit') ?>" 
                                       class="btn btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="<?= base_url('admin/activities/'.$activity['id'].'/delete') ?>" 
                                       class="btn btn-outline-danger" title="Hapus"
                                       onclick="return confirm('Yakin ingin menghapus aktivitas ini? Data akan hilang permanen.')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Pagination -->
<?php if ($pager): ?>
<div class="d-flex justify-content-center mt-4">
    <?= $pager->links() ?>
</div>
<?php endif; ?>
<?= $this->endSection() ?>