<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<!-- Welcome Header -->
<div class="welcome-header mb-4">
    <div class="row align-items-center">
        <div class="col-md-8">
            <div class="welcome-content">
                <h1 class="welcome-title">
                    <i class="fas fa-tachometer-alt me-3"></i>
                    Dashboard Admin
                </h1>
                <p class="welcome-subtitle">
                    Selamat datang kembali, <strong><?= $admin['full_name'] ?></strong>! 
                    Kelola website Anda dengan mudah dari sini.
                </p>
            </div>
        </div>
        <div class="col-md-4 text-end">
            <div class="welcome-time">
                <div class="time-display">
                    <i class="fas fa-clock me-2"></i>
                    <span id="currentTime"><?= date('H:i:s') ?></span>
                </div>
                <div class="date-display">
                    <?= date('d F Y') ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card stat-primary">
            <div class="stat-icon">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">0</div>
                <div class="stat-label">Total Activities</div>
            </div>
            <div class="stat-trend">
                <i class="fas fa-arrow-up"></i>
                <span>+0%</span>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card stat-success">
            <div class="stat-icon">
                <i class="fas fa-user"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">1</div>
                <div class="stat-label">Profile Data</div>
            </div>
            <div class="stat-trend">
                <i class="fas fa-check"></i>
                <span>Active</span>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card stat-info">
            <div class="stat-icon">
                <i class="fas fa-graduation-cap"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">0</div>
                <div class="stat-label">Education Records</div>
            </div>
            <div class="stat-trend">
                <i class="fas fa-arrow-up"></i>
                <span>+0%</span>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card stat-warning">
            <div class="stat-icon">
                <i class="fas fa-user-shield"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number"><?= ucfirst(str_replace('_', ' ', $admin['role'])) ?></div>
                <div class="stat-label">Admin Role</div>
            </div>
            <div class="stat-trend">
                <i class="fas fa-shield-alt"></i>
                <span>Secure</span>
            </div>
        </div>
    </div>
</div>

<!-- Main Content Grid -->
<div class="row">
    <!-- Quick Actions -->
    <div class="col-lg-8 mb-4">
        <div class="dashboard-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-bolt me-2"></i>
                    Quick Actions
                </h5>
                <p class="card-subtitle">Akses cepat ke fitur-fitur utama</p>
            </div>
            <div class="card-body">
                <div class="action-grid">
                    <a href="<?= base_url('admin/activities/new') ?>" class="action-item action-primary">
                        <div class="action-icon">
                            <i class="fas fa-plus"></i>
                        </div>
                        <div class="action-content">
                            <h6>Add Activity</h6>
                            <p>Tambah aktivitas baru</p>
                        </div>
                        <div class="action-arrow">
                            <i class="fas fa-arrow-right"></i>
                        </div>
                    </a>

                    <a href="<?= base_url('admin/profile') ?>" class="action-item action-success">
                        <div class="action-icon">
                            <i class="fas fa-user-edit"></i>
                        </div>
                        <div class="action-content">
                            <h6>Edit Profile</h6>
                            <p>Update profil website</p>
                        </div>
                        <div class="action-arrow">
                            <i class="fas fa-arrow-right"></i>
                        </div>
                    </a>

                    <a href="<?= base_url('admin/education/new') ?>" class="action-item action-info">
                        <div class="action-icon">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div class="action-content">
                            <h6>Add Education</h6>
                            <p>Tambah riwayat pendidikan</p>
                        </div>
                        <div class="action-arrow">
                            <i class="fas fa-arrow-right"></i>
                        </div>
                    </a>

                    <a href="<?= base_url() ?>" target="_blank" class="action-item action-secondary">
                        <div class="action-icon">
                            <i class="fas fa-external-link-alt"></i>
                        </div>
                        <div class="action-content">
                            <h6>View Website</h6>
                            <p>Lihat website frontend</p>
                        </div>
                        <div class="action-arrow">
                            <i class="fas fa-arrow-right"></i>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Admin Info & System -->
    <div class="col-lg-4 mb-4">
        <div class="dashboard-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-user-circle me-2"></i>
                    Admin Profile
                </h5>
            </div>
            <div class="card-body">
                <div class="admin-profile">
                    <div class="admin-avatar">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div class="admin-details">
                        <h6><?= $admin['full_name'] ?></h6>
                        <p class="admin-email"><?= $admin['email'] ?></p>
                        <span class="admin-role-badge"><?= ucfirst(str_replace('_', ' ', $admin['role'])) ?></span>
                    </div>
                </div>
                
                <div class="admin-actions mt-3">
                    <a href="<?= base_url('admin/profile') ?>" class="btn btn-outline-primary btn-sm w-100 mb-2">
                        <i class="fas fa-edit me-2"></i>
                        Edit Profile Website
                    </a>
                    <a href="<?= base_url('admin/logout') ?>" class="btn btn-outline-danger btn-sm w-100" 
                       onclick="return confirm('Yakin ingin logout?')">
                        <i class="fas fa-sign-out-alt me-2"></i>
                        Logout
                    </a>
                </div>
            </div>
        </div>

        <!-- System Info -->
        <div class="dashboard-card mt-4">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-server me-2"></i>
                    System Info
                </h5>
            </div>
            <div class="card-body">
                <div class="system-info">
                    <div class="info-item">
                        <span class="info-label">PHP Version</span>
                        <span class="info-value"><?= phpversion() ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">CodeIgniter</span>
                        <span class="info-value"><?= \CodeIgniter\CodeIgniter::CI_VERSION ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Server Time</span>
                        <span class="info-value"><?= date('H:i:s') ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Status</span>
                        <span class="info-value status-online">
                            <i class="fas fa-circle me-1"></i>
                            Online
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Activity & Quick Links -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="dashboard-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-history me-2"></i>
                    Recent Activity
                </h5>
            </div>
            <div class="card-body">
                <div class="activity-list">
                    <div class="activity-item">
                        <div class="activity-icon activity-success">
                            <i class="fas fa-sign-in-alt"></i>
                        </div>
                        <div class="activity-content">
                            <p class="activity-text">Login berhasil</p>
                            <small class="activity-time">Baru saja</small>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon activity-info">
                            <i class="fas fa-tachometer-alt"></i>
                        </div>
                        <div class="activity-content">
                            <p class="activity-text">Mengakses dashboard</p>
                            <small class="activity-time">Baru saja</small>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon activity-primary">
                            <i class="fas fa-database"></i>
                        </div>
                        <div class="activity-content">
                            <p class="activity-text">Database terhubung</p>
                            <small class="activity-time">Online</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-6 mb-4">
        <div class="dashboard-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-link me-2"></i>
                    Quick Links
                </h5>
            </div>
            <div class="card-body">
                <div class="quick-links">
                    <a href="<?= base_url() ?>" target="_blank" class="quick-link">
                        <i class="fas fa-home"></i>
                        <span>Homepage</span>
                        <i class="fas fa-external-link-alt"></i>
                    </a>
                    <a href="<?= base_url('admin/activities') ?>" class="quick-link">
                        <i class="fas fa-calendar-alt"></i>
                        <span>Manage Activities</span>
                        <i class="fas fa-arrow-right"></i>
                    </a>
                    <a href="<?= base_url('admin/biodata') ?>" class="quick-link">
                        <i class="fas fa-user"></i>
                        <span>Manage Biodata</span>
                        <i class="fas fa-arrow-right"></i>
                    </a>
                    <a href="<?= base_url('admin/education') ?>" class="quick-link">
                        <i class="fas fa-graduation-cap"></i>
                        <span>Manage Education</span>
                        <i class="fas fa-arrow-right"></i>
                    </a>
                    <a href="<?= base_url('admin/profile') ?>" class="quick-link">
                        <i class="fas fa-id-card"></i>
                        <span>Website Profile</span>
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Dashboard Styles */
.welcome-header {
    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
    border: 2px solid rgba(30, 64, 175, 0.1);
    border-radius: 20px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 8px 25px rgba(15, 23, 42, 0.1);
}

.welcome-title {
    font-size: 2.2rem;
    font-weight: 800;
    background: linear-gradient(135deg, #0f172a 0%, #1e40af 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin-bottom: 0.5rem;
}

.welcome-subtitle {
    color: #64748b;
    font-size: 1.1rem;
    margin: 0;
}

.welcome-time {
    text-align: right;
}

.time-display {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1e40af;
    margin-bottom: 0.5rem;
}

.date-display {
    color: #64748b;
    font-size: 0.9rem;
}

/* Stat Cards */
.stat-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 4px 15px rgba(15, 23, 42, 0.1);
    border: 2px solid transparent;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
}

.stat-card.stat-primary::before { background: linear-gradient(135deg, #1e40af, #3b82f6); }
.stat-card.stat-success::before { background: linear-gradient(135deg, #059669, #10b981); }
.stat-card.stat-info::before { background: linear-gradient(135deg, #0284c7, #0ea5e9); }
.stat-card.stat-warning::before { background: linear-gradient(135deg, #d97706, #f59e0b); }

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(15, 23, 42, 0.15);
}

.stat-card {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
}

.stat-primary .stat-icon { background: linear-gradient(135deg, #1e40af, #3b82f6); }
.stat-success .stat-icon { background: linear-gradient(135deg, #059669, #10b981); }
.stat-info .stat-icon { background: linear-gradient(135deg, #0284c7, #0ea5e9); }
.stat-warning .stat-icon { background: linear-gradient(135deg, #d97706, #f59e0b); }

.stat-content {
    flex: 1;
}

.stat-number {
    font-size: 2rem;
    font-weight: 800;
    color: #0f172a;
    margin-bottom: 0.25rem;
}

.stat-label {
    color: #64748b;
    font-size: 0.9rem;
    font-weight: 500;
}

.stat-trend {
    text-align: right;
    font-size: 0.8rem;
    font-weight: 600;
}

.stat-primary .stat-trend { color: #1e40af; }
.stat-success .stat-trend { color: #059669; }
.stat-info .stat-trend { color: #0284c7; }
.stat-warning .stat-trend { color: #d97706; }

/* Dashboard Cards */
.dashboard-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 15px rgba(15, 23, 42, 0.1);
    border: 2px solid rgba(30, 64, 175, 0.1);
    overflow: hidden;
    transition: all 0.3s ease;
}

.dashboard-card:hover {
    box-shadow: 0 8px 25px rgba(15, 23, 42, 0.15);
    border-color: rgba(30, 64, 175, 0.2);
}

.dashboard-card .card-header {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    border-bottom: 2px solid rgba(30, 64, 175, 0.1);
    padding: 1.5rem;
}

.dashboard-card .card-title {
    font-size: 1.2rem;
    font-weight: 700;
    color: #0f172a;
    margin: 0;
}

.dashboard-card .card-subtitle {
    color: #64748b;
    font-size: 0.9rem;
    margin: 0.5rem 0 0 0;
}

.dashboard-card .card-body {
    padding: 1.5rem;
}

/* Action Grid */
.action-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1rem;
}

.action-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.action-item.action-primary {
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.05), rgba(59, 130, 246, 0.05));
    border-color: rgba(30, 64, 175, 0.1);
}

.action-item.action-success {
    background: linear-gradient(135deg, rgba(5, 150, 105, 0.05), rgba(16, 185, 129, 0.05));
    border-color: rgba(5, 150, 105, 0.1);
}

.action-item.action-info {
    background: linear-gradient(135deg, rgba(2, 132, 199, 0.05), rgba(14, 165, 233, 0.05));
    border-color: rgba(2, 132, 199, 0.1);
}

.action-item.action-secondary {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.05), rgba(30, 41, 59, 0.05));
    border-color: rgba(15, 23, 42, 0.1);
}

.action-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(15, 23, 42, 0.1);
    text-decoration: none;
}

.action-icon {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    color: white;
}

.action-primary .action-icon { background: linear-gradient(135deg, #1e40af, #3b82f6); }
.action-success .action-icon { background: linear-gradient(135deg, #059669, #10b981); }
.action-info .action-icon { background: linear-gradient(135deg, #0284c7, #0ea5e9); }
.action-secondary .action-icon { background: linear-gradient(135deg, #0f172a, #1e293b); }

.action-content {
    flex: 1;
}

.action-content h6 {
    font-weight: 700;
    color: #0f172a;
    margin: 0 0 0.25rem 0;
}

.action-content p {
    color: #64748b;
    font-size: 0.9rem;
    margin: 0;
}

.action-arrow {
    color: #64748b;
    transition: all 0.3s ease;
}

.action-item:hover .action-arrow {
    transform: translateX(5px);
    color: #1e40af;
}

/* Admin Profile */
.admin-profile {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1rem;
}

.admin-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, #0f172a, #1e40af);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.admin-details h6 {
    font-weight: 700;
    color: #0f172a;
    margin: 0 0 0.25rem 0;
}

.admin-email {
    color: #64748b;
    font-size: 0.9rem;
    margin: 0 0 0.5rem 0;
}

.admin-role-badge {
    background: linear-gradient(135deg, #1e40af, #3b82f6);
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
}

/* System Info */
.system-info {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.info-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.5rem 0;
    border-bottom: 1px solid rgba(30, 64, 175, 0.1);
}

.info-item:last-child {
    border-bottom: none;
}

.info-label {
    color: #64748b;
    font-size: 0.9rem;
}

.info-value {
    font-weight: 600;
    color: #0f172a;
}

.status-online {
    color: #059669 !important;
}

/* Activity List */
.activity-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.activity-item {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.9rem;
}

.activity-icon.activity-success { background: linear-gradient(135deg, #059669, #10b981); }
.activity-icon.activity-info { background: linear-gradient(135deg, #0284c7, #0ea5e9); }
.activity-icon.activity-primary { background: linear-gradient(135deg, #1e40af, #3b82f6); }

.activity-content {
    flex: 1;
}

.activity-text {
    font-weight: 600;
    color: #0f172a;
    margin: 0 0 0.25rem 0;
}

.activity-time {
    color: #64748b;
    font-size: 0.8rem;
}

/* Quick Links */
.quick-links {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.quick-link {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.75rem;
    border-radius: 8px;
    text-decoration: none;
    color: #0f172a;
    transition: all 0.3s ease;
    border: 1px solid rgba(30, 64, 175, 0.1);
}

.quick-link:hover {
    background: linear-gradient(135deg, rgba(30, 64, 175, 0.05), rgba(59, 130, 246, 0.05));
    color: #1e40af;
    text-decoration: none;
    transform: translateX(5px);
}

.quick-link i:first-child {
    color: #1e40af;
    width: 20px;
}

.quick-link span {
    flex: 1;
    font-weight: 500;
}

.quick-link i:last-child {
    color: #64748b;
    font-size: 0.8rem;
}

/* Responsive */
@media (max-width: 768px) {
    .welcome-header {
        padding: 1.5rem;
    }
    
    .welcome-title {
        font-size: 1.8rem;
    }
    
    .action-grid {
        grid-template-columns: 1fr;
    }
    
    .stat-card {
        flex-direction: column;
        text-align: center;
        gap: 0.5rem;
    }
    
    .admin-profile {
        flex-direction: column;
        text-align: center;
    }
}
</style>

<script>
// Update time every second
function updateTime() {
    const now = new Date();
    const timeString = now.toLocaleTimeString('id-ID');
    document.getElementById('currentTime').textContent = timeString;
}

// Update time immediately and then every second
updateTime();
setInterval(updateTime, 1000);

// Add some interactive effects
document.addEventListener('DOMContentLoaded', function() {
    // Animate stat cards on load
    const statCards = document.querySelectorAll('.stat-card');
    statCards.forEach((card, index) => {
        setTimeout(() => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'all 0.5s ease';
            
            setTimeout(() => {
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, 100);
        }, index * 100);
    });
});
</script>
<?= $this->endSection() ?>