<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Tambah Pendidikan</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('admin/education') ?>">Pendidikan</a></li>
                <li class="breadcrumb-item active">Tambah Baru</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <form action="<?= base_url('admin/education/create') ?>" method="post">
                    <?= csrf_field() ?>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="jenjang" class="form-label">Jenjang Pendidikan</label>
                            <select class="form-control <?= $validation->hasError('jenjang') ? 'is-invalid' : '' ?>" 
                                    id="jenjang" name="jenjang" required>
                                <option value="">Pilih Jenjang</option>
                                <option value="SD" <?= old('jenjang') == 'SD' ? 'selected' : '' ?>>SD</option>
                                <option value="SMP" <?= old('jenjang') == 'SMP' ? 'selected' : '' ?>>SMP</option>
                                <option value="SMA" <?= old('jenjang') == 'SMA' ? 'selected' : '' ?>>SMA</option>
                                <option value="S1" <?= old('jenjang') == 'S1' ? 'selected' : '' ?>>S1</option>
                                <option value="S2" <?= old('jenjang') == 'S2' ? 'selected' : '' ?>>S2</option>
                                <option value="S3" <?= old('jenjang') == 'S3' ? 'selected' : '' ?>>S3</option>
                            </select>
                            <?php if ($validation->hasError('jenjang')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('jenjang') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="nama_sekolah" class="form-label">Nama Sekolah/Universitas</label>
                            <input type="text" class="form-control <?= $validation->hasError('nama_sekolah') ? 'is-invalid' : '' ?>" 
                                   id="nama_sekolah" name="nama_sekolah" value="<?= old('nama_sekolah') ?>" required>
                            <?php if ($validation->hasError('nama_sekolah')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('nama_sekolah') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="jurusan" class="form-label">Jurusan/Program Studi</label>
                            <input type="text" class="form-control" id="jurusan" name="jurusan" value="<?= old('jurusan') ?>">
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="ipk" class="form-label">IPK/Nilai</label>
                            <input type="number" step="0.01" min="0" max="4" class="form-control" 
                                   id="ipk" name="ipk" value="<?= old('ipk') ?>">
                            <div class="form-text">Skala 0-4 untuk IPK atau 0-100 untuk nilai</div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
                            <input type="number" class="form-control <?= $validation->hasError('tahun_mulai') ? 'is-invalid' : '' ?>" 
                                   id="tahun_mulai" name="tahun_mulai" value="<?= old('tahun_mulai') ?>" 
                                   min="1900" max="<?= date('Y') ?>" required>
                            <?php if ($validation->hasError('tahun_mulai')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('tahun_mulai') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
                            <input type="number" class="form-control <?= $validation->hasError('tahun_selesai') ? 'is-invalid' : '' ?>" 
                                   id="tahun_selesai" name="tahun_selesai" value="<?= old('tahun_selesai') ?>" 
                                   min="1900" max="<?= date('Y') + 10 ?>" required>
                            <?php if ($validation->hasError('tahun_selesai')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('tahun_selesai') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="keterangan" class="form-label">Keterangan</label>
                        <textarea class="form-control" id="keterangan" name="keterangan" rows="3" 
                                  placeholder="Prestasi, penghargaan, atau keterangan lainnya"><?= old('keterangan') ?></textarea>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            Simpan
                        </button>
                        <a href="<?= base_url('admin/education') ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>
                            Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-graduation-cap me-2"></i>
                    Panduan
                </h5>
            </div>
            <div class="card-body">
                <h6>Jenjang Pendidikan:</h6>
                <ul class="list-unstyled">
                    <li><strong>SD:</strong> Sekolah Dasar</li>
                    <li><strong>SMP:</strong> Sekolah Menengah Pertama</li>
                    <li><strong>SMA:</strong> Sekolah Menengah Atas/SMK</li>
                    <li><strong>S1:</strong> Sarjana</li>
                    <li><strong>S2:</strong> Magister</li>
                    <li><strong>S3:</strong> Doktor</li>
                </ul>
                
                <h6 class="mt-3">Tips:</h6>
                <ul class="list-unstyled">
                    <li>• Isi nama sekolah/universitas lengkap</li>
                    <li>• Jurusan opsional untuk SD/SMP</li>
                    <li>• IPK untuk perguruan tinggi</li>
                    <li>• Keterangan untuk prestasi khusus</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>