<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Pendidikan</h3>
                    <div class="card-tools">
                        <a href="<?= base_url('admin/education') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (session()->getFlashdata('error')): ?>
                        <div class="alert alert-danger">
                            <?= session()->getFlashdata('error') ?>
                        </div>
                    <?php endif; ?>

                    <form action="<?= base_url('admin/education/edit/' . $education['id']) ?>" method="post">
                        <?= csrf_field() ?>
                        <input type="hidden" name="id" value="<?= $education['id'] ?>">
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jenjang">Jenjang Pendidikan <span class="text-danger">*</span></label>
                                    <select class="form-control <?= $validation->hasError('jenjang') ? 'is-invalid' : '' ?>" 
                                            id="jenjang" name="jenjang" required>
                                        <option value="">Pilih Jenjang</option>
                                        <option value="SD" <?= old('jenjang', $education['jenjang']) == 'SD' ? 'selected' : '' ?>>SD</option>
                                        <option value="SMP" <?= old('jenjang', $education['jenjang']) == 'SMP' ? 'selected' : '' ?>>SMP</option>
                                        <option value="SMA" <?= old('jenjang', $education['jenjang']) == 'SMA' ? 'selected' : '' ?>>SMA</option>
                                        <option value="S1" <?= old('jenjang', $education['jenjang']) == 'S1' ? 'selected' : '' ?>>S1</option>
                                        <option value="S2" <?= old('jenjang', $education['jenjang']) == 'S2' ? 'selected' : '' ?>>S2</option>
                                        <option value="S3" <?= old('jenjang', $education['jenjang']) == 'S3' ? 'selected' : '' ?>>S3</option>
                                    </select>
                                    <?php if ($validation->hasError('jenjang')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('jenjang') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_sekolah">Nama Sekolah/Universitas <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?= $validation->hasError('nama_sekolah') ? 'is-invalid' : '' ?>" 
                                           id="nama_sekolah" name="nama_sekolah" value="<?= old('nama_sekolah', $education['nama_sekolah']) ?>" required>
                                    <?php if ($validation->hasError('nama_sekolah')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('nama_sekolah') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jurusan">Jurusan/Program Studi</label>
                                    <input type="text" class="form-control" id="jurusan" name="jurusan" 
                                           value="<?= old('jurusan', $education['jurusan']) ?>">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ipk">IPK/Nilai</label>
                                    <input type="number" step="0.01" min="0" max="4" class="form-control" 
                                           id="ipk" name="ipk" value="<?= old('ipk', $education['ipk']) ?>">
                                    <small class="form-text text-muted">Skala 0-4 untuk IPK atau 0-100 untuk nilai</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tahun_mulai">Tahun Mulai <span class="text-danger">*</span></label>
                                    <input type="number" min="1900" max="<?= date('Y') ?>" 
                                           class="form-control <?= $validation->hasError('tahun_mulai') ? 'is-invalid' : '' ?>" 
                                           id="tahun_mulai" name="tahun_mulai" value="<?= old('tahun_mulai', $education['tahun_mulai']) ?>" required>
                                    <?php if ($validation->hasError('tahun_mulai')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('tahun_mulai') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tahun_selesai">Tahun Selesai <span class="text-danger">*</span></label>
                                    <input type="number" min="1900" max="<?= date('Y') + 10 ?>" 
                                           class="form-control <?= $validation->hasError('tahun_selesai') ? 'is-invalid' : '' ?>" 
                                           id="tahun_selesai" name="tahun_selesai" value="<?= old('tahun_selesai', $education['tahun_selesai']) ?>" required>
                                    <?php if ($validation->hasError('tahun_selesai')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('tahun_selesai') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="keterangan">Keterangan</label>
                                    <textarea class="form-control" id="keterangan" name="keterangan" rows="3" 
                                              placeholder="Prestasi, penghargaan, atau keterangan lainnya"><?= old('keterangan', $education['keterangan']) ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Pendidikan
                            </button>
                            <a href="<?= base_url('admin/education') ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>