<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Kelola Pendidikan</h1>
        <p class="text-muted">Manajemen data riwayat pendidikan</p>
    </div>
    <a href="<?= base_url('admin/education/create') ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>
        Tambah Pendidikan
    </a>
</div>

<!-- Search and Filter -->
<div class="card mb-4">
    <div class="card-body">
        <form method="get" action="<?= base_url('admin/education') ?>">
            <div class="row">
                <div class="col-md-4 mb-2">
                    <input type="text" name="search" class="form-control" placeholder="Cari nama sekolah, jurusan..." value="<?= esc($search) ?>">
                </div>
                <div class="col-md-3 mb-2">
                    <select name="filter_jenjang" class="form-control">
                        <option value="">Semua Jenjang</option>
                        <option value="SD" <?= $filter_jenjang == 'SD' ? 'selected' : '' ?>>SD</option>
                        <option value="SMP" <?= $filter_jenjang == 'SMP' ? 'selected' : '' ?>>SMP</option>
                        <option value="SMA" <?= $filter_jenjang == 'SMA' ? 'selected' : '' ?>>SMA</option>
                        <option value="S1" <?= $filter_jenjang == 'S1' ? 'selected' : '' ?>>S1</option>
                        <option value="S2" <?= $filter_jenjang == 'S2' ? 'selected' : '' ?>>S2</option>
                        <option value="S3" <?= $filter_jenjang == 'S3' ? 'selected' : '' ?>>S3</option>
                    </select>
                </div>
                <div class="col-md-2 mb-2">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search me-1"></i>
                        Cari
                    </button>
                </div>
                <div class="col-md-2 mb-2">
                    <a href="<?= base_url('admin/education') ?>" class="btn btn-secondary w-100">
                        <i class="fas fa-refresh me-1"></i>
                        Reset
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Sorting Links -->
<div class="mb-3">
    <small class="text-muted"><strong>Urutkan berdasarkan:</strong></small>
    <div class="btn-group btn-group-sm ms-2">
        <a href="<?= base_url('admin/education?sort_by=nama_sekolah&sort_order=' . ($sort_by == 'nama_sekolah' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>" 
           class="btn btn-outline-secondary">
            Sekolah <?= $sort_by == 'nama_sekolah' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/education?sort_by=jenjang&sort_order=' . ($sort_by == 'jenjang' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>" 
           class="btn btn-outline-secondary">
            Jenjang <?= $sort_by == 'jenjang' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/education?sort_by=tahun_mulai&sort_order=' . ($sort_by == 'tahun_mulai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>" 
           class="btn btn-outline-secondary">
            Tahun Mulai <?= $sort_by == 'tahun_mulai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<!-- Data Table -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Jenjang</th>
                        <th>Sekolah/Universitas</th>
                        <th>Jurusan</th>
                        <th>Periode</th>
                        <th>IPK</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($educations)): ?>
                        <tr>
                            <td colspan="7" class="text-center py-4">
                                <i class="fas fa-graduation-cap fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada data pendidikan</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach($educations as $edu): ?>
                        <tr>
                            <td><?= $edu['id'] ?></td>
                            <td>
                                <span class="badge bg-primary">
                                    <?= esc($edu['jenjang']) ?>
                                </span>
                            </td>
                            <td>
                                <strong><?= esc($edu['nama_sekolah']) ?></strong>
                            </td>
                            <td><?= esc($edu['jurusan'] ?? '-') ?></td>
                            <td>
                                <small class="text-muted">
                                    <?= $edu['tahun_mulai'] ?> - <?= $edu['tahun_selesai'] ?>
                                </small>
                            </td>
                            <td>
                                <?php if (!empty($edu['ipk']) && $edu['ipk'] > 0): ?>
                                    <span class="badge bg-success">
                                        <?= number_format($edu['ipk'], 2) ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?= base_url('admin/education/'.$edu['id'].'/preview') ?>" 
                                       class="btn btn-outline-info" title="Preview" target="_blank">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?= base_url('admin/education/edit/'.$edu['id']) ?>" 
                                       class="btn btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="<?= base_url('admin/education/'.$edu['id'].'/delete') ?>" 
                                       class="btn btn-outline-danger" title="Hapus"
                                       onclick="return confirm('Yakin ingin menghapus data pendidikan ini? Data akan hilang permanen.')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Pagination -->
<?php if ($pager): ?>
<div class="d-flex justify-content-center mt-4">
    <?= $pager->links() ?>
</div>
<?php endif; ?>
<?= $this->endSection() ?>