<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Admin Panel' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --sidebar-width: 250px;
            --primary-color: #1e40af;
            --secondary-color: #0f172a;
            --accent-color: #3b82f6;
        }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 25%, #dbeafe 75%, #1e40af 100%);
            min-height: 100vh;
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: linear-gradient(180deg, var(--secondary-color) 0%, var(--primary-color) 100%);
            color: white;
            z-index: 1000;
            transition: all 0.3s ease;
            border-right: 3px solid rgba(255, 255, 255, 0.1);
            box-shadow: 4px 0 15px rgba(15, 23, 42, 0.2);
        }

        .sidebar-header {
            padding: 1.5rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            background: rgba(255, 255, 255, 0.05);
        }

        .sidebar-header h4 {
            margin: 0;
            font-weight: 700;
            font-size: 1.2rem;
        }

        .sidebar-header small {
            font-size: 0.85rem;
            opacity: 0.8;
        }

        .sidebar-menu {
            padding: 1rem 0;
        }

        .sidebar-menu .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.75rem 1.5rem;
            border-radius: 0;
            transition: all 0.3s ease;
            border-left: 3px solid transparent;
            font-weight: 500;
        }

        .sidebar-menu .nav-link:hover,
        .sidebar-menu .nav-link.active {
            color: white;
            background-color: rgba(255, 255, 255, 0.1);
            transform: translateX(5px);
            border-left-color: white;
        }

        .sidebar-menu .nav-link i {
            width: 20px;
            text-align: center;
        }

        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
        }

        .navbar {
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            box-shadow: 0 4px 15px rgba(15, 23, 42, 0.2);
            border-bottom: 2px solid var(--primary-color);
        }

        .content-wrapper {
            padding: 2rem;
            background: rgba(255, 255, 255, 0.02);
            min-height: calc(100vh - 76px);
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 25px rgba(15, 23, 42, 0.15);
            border: 2px solid rgba(30, 64, 175, 0.2);
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
            border: none;
            box-shadow: 0 4px 15px rgba(15, 23, 42, 0.3);
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(30, 64, 175, 0.4);
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                z-index: 1050;
                box-shadow: 4px 0 15px rgba(15, 23, 42, 0.3);
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }

            .content-wrapper {
                padding: 1rem;
            }

            .navbar {
                padding: 0.5rem 1rem;
            }

            .card {
                margin-bottom: 1rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .table-responsive {
                font-size: 0.875rem;
            }

            .btn {
                padding: 0.5rem 1rem;
                font-size: 0.875rem;
            }

            .btn-group .btn {
                padding: 0.375rem 0.75rem;
                font-size: 0.8rem;
            }

            .form-control {
                padding: 0.5rem 0.75rem;
                font-size: 16px; /* Prevents zoom on iOS */
            }

            .form-label {
                font-size: 0.875rem;
                margin-bottom: 0.5rem;
            }

            .breadcrumb {
                font-size: 0.8rem;
                margin-bottom: 1rem;
            }

            .alert {
                padding: 0.75rem 1rem;
                font-size: 0.875rem;
            }

            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                min-width: 200px;
            }

            .sidebar-header h4 {
                font-size: 1.1rem;
            }

            .sidebar-header small {
                font-size: 0.75rem;
            }

            .sidebar-menu .nav-link {
                padding: 0.625rem 1rem;
                font-size: 0.9rem;
            }

            .sidebar-menu .nav-link i {
                width: 18px;
                font-size: 0.875rem;
            }
        }

        @media (max-width: 576px) {
            .content-wrapper {
                padding: 0.75rem;
            }

            .card-body {
                padding: 1rem;
            }

            .card-header {
                padding: 1rem;
            }

            .btn {
                padding: 0.5rem 0.875rem;
                font-size: 0.8rem;
            }

            .btn-sm {
                padding: 0.375rem 0.625rem;
                font-size: 0.75rem;
            }

            .form-control {
                padding: 0.5rem;
                font-size: 16px;
            }

            .table {
                font-size: 0.8rem;
            }

            .table th,
            .table td {
                padding: 0.5rem 0.25rem;
            }

            .breadcrumb {
                font-size: 0.75rem;
                padding: 0.5rem 0;
            }

            .alert {
                padding: 0.625rem 0.875rem;
                font-size: 0.8rem;
            }

            .sidebar-header {
                padding: 1rem;
            }

            .sidebar-header h4 {
                font-size: 1rem;
            }

            .sidebar-menu .nav-link {
                padding: 0.5rem 0.875rem;
                font-size: 0.85rem;
            }

            .navbar {
                padding: 0.375rem 0.75rem;
            }

            .navbar-brand {
                font-size: 1rem;
            }

            .dropdown-menu {
                font-size: 0.85rem;
            }

            .dropdown-item {
                padding: 0.5rem 1rem;
            }

            /* Mobile-specific utilities */
            .mobile-scroll {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }

            .mobile-stack {
                flex-direction: column;
            }

            .mobile-full-width {
                width: 100%;
            }

            .mobile-text-center {
                text-align: center;
            }

            .mobile-hidden {
                display: none;
            }
        }

        /* Landscape mobile optimization */
        @media (max-width: 768px) and (orientation: landscape) {
            .sidebar {
                width: 200px;
            }

            .sidebar-header {
                padding: 0.75rem;
            }

            .sidebar-header h4 {
                font-size: 0.95rem;
            }

            .sidebar-menu .nav-link {
                padding: 0.5rem 0.75rem;
                font-size: 0.8rem;
            }

            .content-wrapper {
                padding: 0.75rem;
            }
        }

        /* Touch-friendly improvements */
        @media (hover: none) and (pointer: coarse) {
            .btn,
            .nav-link,
            .dropdown-item {
                min-height: 44px;
                display: flex;
                align-items: center;
            }

            .sidebar-menu .nav-link {
                min-height: 48px;
            }

            .table tbody tr {
                min-height: 48px;
            }

            .form-control {
                min-height: 44px;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <nav class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h4 class="mb-0">
                <i class="fas fa-cogs me-2"></i>
                Admin Panel
            </h4>
            <small class="opacity-75">Management System</small>
        </div>
        
        <div class="sidebar-menu">
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?= (current_url() == base_url('admin/dashboard')) ? 'active' : '' ?>" 
                       href="<?= base_url('admin/dashboard') ?>">
                        <i class="fas fa-tachometer-alt me-2"></i>
                        Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= (strpos(current_url(), 'admin/activities') !== false) ? 'active' : '' ?>" 
                       href="<?= base_url('admin/activities') ?>">
                        <i class="fas fa-calendar-alt me-2"></i>
                        Activities
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= (strpos(current_url(), 'admin/biodata') !== false) ? 'active' : '' ?>" 
                       href="<?= base_url('admin/biodata') ?>">
                        <i class="fas fa-user me-2"></i>
                        Biodata
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= (strpos(current_url(), 'admin/education') !== false) ? 'active' : '' ?>" 
                       href="<?= base_url('admin/education') ?>">
                        <i class="fas fa-graduation-cap me-2"></i>
                        Education
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= (strpos(current_url(), 'admin/profile') !== false) ? 'active' : '' ?>" 
                       href="<?= base_url('admin/profile') ?>">
                        <i class="fas fa-id-card me-2"></i>
                        Kelola Profile
                    </a>
                </li>
                <?php if (is_super_admin()): ?>
                <li class="nav-item">
                    <a class="nav-link <?= (strpos(current_url(), 'admin/management') !== false) ? 'active' : '' ?>" 
                       href="<?= base_url('admin/management') ?>">
                        <i class="fas fa-users-cog me-2"></i>
                        Kelola Admin
                    </a>
                </li>
                <?php endif; ?>
                <li class="nav-item mt-3">
                    <hr class="text-white-50">
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/logout') ?>" 
                       onclick="return confirm('Yakin ingin logout?')">
                        <i class="fas fa-sign-out-alt me-2"></i>
                        Logout
                    </a>
                </li>
            </ul>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navbar -->
        <nav class="navbar navbar-expand-lg navbar-light">
            <div class="container-fluid">
                <button class="btn btn-outline-secondary d-md-none" type="button" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                
                <div class="navbar-nav ms-auto">
                    <div class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" 
                           id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle me-2 fs-5"></i>
                            <span><?= session()->get('admin_full_name') ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="<?= base_url('admin/profile') ?>">
                                    <i class="fas fa-user-cog me-2"></i>
                                    Profile
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item text-danger" href="<?= base_url('admin/logout') ?>"
                                   onclick="return confirm('Yakin ingin logout?')">
                                    <i class="fas fa-sign-out-alt me-2"></i>
                                    Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Content Wrapper -->
        <div class="content-wrapper">
            <?php if (session()->getFlashdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= session()->getFlashdata('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?= session()->getFlashdata('error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('warning')): ?>
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?= session()->getFlashdata('warning') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Page Content -->
            <?= $this->renderSection('content') ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Sidebar toggle for mobile
        document.getElementById('sidebarToggle')?.addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Auto dismiss alerts
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(e) {
            const sidebar = document.getElementById('sidebar');
            const sidebarToggle = document.getElementById('sidebarToggle');
            
            if (window.innerWidth <= 768 && 
                !sidebar.contains(e.target) && 
                !sidebarToggle?.contains(e.target)) {
                sidebar.classList.remove('show');
            }
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>