<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Edit Profile</h1>
        <p class="text-muted">Update informasi profil dan foto</p>
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?= base_url('admin/profile') ?>">Profile</a></li>
            <li class="breadcrumb-item active">Edit</li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-edit me-2"></i>
                    Form Edit Profile
                </h5>
            </div>
            <div class="card-body">
                <form action="<?= base_url('admin/profile/' . $profile['id'] . '/update') ?>" 
                      method="post" enctype="multipart/form-data" id="profileForm">
                    <?= csrf_field() ?>
                    
                    <!-- Flash Messages -->
                    <?php if (session()->getFlashdata('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            <?= session()->getFlashdata('success') ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (session()->getFlashdata('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <?= session()->getFlashdata('error') ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Debug info -->
                    <div class="alert alert-info">
                        <small>
                            <strong>Debug Info:</strong><br>
                            Form action: <?= base_url('admin/profile/' . $profile['id'] . '/update') ?><br>
                            Profile ID: <?= $profile['id'] ?><br>
                            Current photo: <?= $profile['photo'] ?? 'None' ?><br>
                            Upload directory: <?= FCPATH . 'uploads/profile/' ?><br>
                            Directory exists: <?= is_dir(FCPATH . 'uploads/profile/') ? 'Yes' : 'No' ?><br>
                            Directory writable: <?= is_writable(FCPATH . 'uploads/profile/') ? 'Yes' : 'No' ?><br>
                            Max upload size: <?= ini_get('upload_max_filesize') ?><br>
                            Post max size: <?= ini_get('post_max_size') ?>
                        </small>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label">Nama Lengkap *</label>
                            <input type="text" 
                                   class="form-control <?= $validation->hasError('name') ? 'is-invalid' : '' ?>" 
                                   id="name" 
                                   name="name" 
                                   value="<?= old('name', $profile['name']) ?>" 
                                   required>
                            <?php if ($validation->hasError('name')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('name') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="title" class="form-label">Jabatan/Title</label>
                            <input type="text" 
                                   class="form-control <?= $validation->hasError('title') ? 'is-invalid' : '' ?>" 
                                   id="title" 
                                   name="title" 
                                   value="<?= old('title', $profile['title']) ?>">
                            <?php if ($validation->hasError('title')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('title') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Deskripsi</label>
                        <textarea class="form-control <?= $validation->hasError('description') ? 'is-invalid' : '' ?>" 
                                  id="description" 
                                  name="description" 
                                  rows="4"><?= old('description', $profile['description']) ?></textarea>
                        <?php if ($validation->hasError('description')): ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('description') ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="mb-3">
                        <label for="photo" class="form-label">Foto Profil</label>
                        <input type="file" 
                               class="form-control <?= $validation->hasError('photo') ? 'is-invalid' : '' ?>" 
                               id="photo" 
                               name="photo" 
                               accept="image/*">
                        <div class="form-text">
                            Format: JPG, JPEG, PNG, GIF. Maksimal 2MB.
                        </div>
                        <?php if ($validation->hasError('photo')): ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('photo') ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" 
                                   class="form-control <?= $validation->hasError('email') ? 'is-invalid' : '' ?>" 
                                   id="email" 
                                   name="email" 
                                   value="<?= old('email', $profile['email']) ?>">
                            <?php if ($validation->hasError('email')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('email') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">Telepon</label>
                            <input type="text" 
                                   class="form-control <?= $validation->hasError('phone') ? 'is-invalid' : '' ?>" 
                                   id="phone" 
                                   name="phone" 
                                   value="<?= old('phone', $profile['phone']) ?>">
                            <?php if ($validation->hasError('phone')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('phone') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="address" class="form-label">Alamat</label>
                        <textarea class="form-control <?= $validation->hasError('address') ? 'is-invalid' : '' ?>" 
                                  id="address" 
                                  name="address" 
                                  rows="3"><?= old('address', $profile['address']) ?></textarea>
                        <?php if ($validation->hasError('address')): ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('address') ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="<?= base_url('admin/profile') ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>
                            Kembali
                        </a>
                        <button type="submit" class="btn btn-primary" id="submitBtn">
                            <i class="fas fa-save me-2"></i>
                            Update Profile
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <!-- Current Photo Preview -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Foto Saat Ini</h6>
            </div>
            <div class="card-body text-center">
                <?php if (!empty($profile['photo'])): ?>
                    <img src="<?= base_url('uploads/profile/' . $profile['photo']) ?>" 
                         alt="<?= esc($profile['name']) ?>" 
                         class="profile-photo-preview">
                    <div class="mt-3">
                        <a href="<?= base_url('admin/profile/' . $profile['id'] . '/delete-photo') ?>" 
                           class="btn btn-danger btn-sm"
                           onclick="return confirm('Yakin ingin menghapus foto?')">
                            <i class="fas fa-trash me-1"></i>
                            Hapus Foto
                        </a>
                    </div>
                <?php else: ?>
                    <div class="profile-photo-placeholder">
                        <i class="fas fa-user fa-3x text-muted"></i>
                        <p class="mt-2 text-muted">Belum ada foto</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Tips -->
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-lightbulb me-2"></i>
                    Tips
                </h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Gunakan foto dengan resolusi tinggi
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Format JPG/PNG untuk hasil terbaik
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Foto akan otomatis di-crop menjadi bulat
                    </li>
                    <li class="mb-0">
                        <i class="fas fa-check text-success me-2"></i>
                        Maksimal ukuran file 2MB
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
.profile-photo-preview {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid #1e40af;
}

.profile-photo-placeholder {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    background: #f8fafc;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    border: 3px solid #e2e8f0;
    margin: 0 auto;
}

.upload-progress {
    display: none;
    margin-top: 10px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const photoInput = document.getElementById('photo');
    const form = document.getElementById('profileForm');
    const submitBtn = document.getElementById('submitBtn');
    
    // Preview selected image
    photoInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            // Validate file size (2MB = 2097152 bytes)
            if (file.size > 2097152) {
                alert('File terlalu besar! Maksimal 2MB.');
                this.value = '';
                return;
            }
            
            // Validate file type
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
            if (!allowedTypes.includes(file.type)) {
                alert('Format file tidak didukung! Gunakan JPG, PNG, atau GIF.');
                this.value = '';
                return;
            }
            
            // Show preview
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.querySelector('.profile-photo-preview');
                if (preview) {
                    preview.src = e.target.result;
                } else {
                    // Create preview if doesn't exist
                    const placeholder = document.querySelector('.profile-photo-placeholder');
                    if (placeholder) {
                        placeholder.innerHTML = '<img src="' + e.target.result + '" class="profile-photo-preview" alt="Preview">';
                    }
                }
            };
            reader.readAsDataURL(file);
        }
    });
    
    // Form submission handling
    form.addEventListener('submit', function(e) {
        const file = photoInput.files[0];
        if (file) {
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Uploading...';
            submitBtn.disabled = true;
        }
    });
});
</script>
<?= $this->endSection() ?>