<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Kelola Profile</h1>
        <p class="text-muted">Kelola informasi profil dan foto yang ditampilkan di beranda</p>
    </div>
</div>

<?php if ($profile): ?>
<div class="row">
    <div class="col-lg-4">
        <!-- Profile Photo Card -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-camera me-2"></i>
                    Foto Profil
                </h5>
            </div>
            <div class="card-body text-center">
                <div class="profile-photo-preview mb-3">
                    <?php if (!empty($profile['photo'])): ?>
                        <img src="<?= base_url('uploads/profile/' . $profile['photo']) ?>" 
                             alt="<?= esc($profile['name']) ?>" 
                             class="profile-photo-admin">
                        <div class="mt-3">
                            <a href="<?= base_url('admin/profile/' . $profile['id'] . '/delete-photo') ?>" 
                               class="btn btn-danger btn-sm"
                               onclick="return confirm('Yakin ingin menghapus foto?')">
                                <i class="fas fa-trash me-1"></i>
                                Hapus Foto
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="profile-photo-placeholder-admin">
                            <i class="fas fa-user fa-3x text-muted"></i>
                            <p class="mt-2 text-muted">Belum ada foto</p>
                        </div>
                    <?php endif; ?>
                </div>
                
                <a href="<?= base_url('admin/profile/' . $profile['id'] . '/edit') ?>" 
                   class="btn btn-primary">
                    <i class="fas fa-edit me-1"></i>
                    Edit Profile
                </a>
            </div>
        </div>
    </div>

    <div class="col-lg-8">
        <!-- Profile Info Card -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-user me-2"></i>
                    Informasi Profile
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <strong>Nama:</strong><br>
                        <span class="text-muted"><?= esc($profile['name']) ?></span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Jabatan/Title:</strong><br>
                        <span class="text-muted"><?= esc($profile['title'] ?? '-') ?></span>
                    </div>
                    <div class="col-12 mb-3">
                        <strong>Deskripsi:</strong><br>
                        <span class="text-muted"><?= esc($profile['description'] ?? '-') ?></span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Email:</strong><br>
                        <span class="text-muted"><?= esc($profile['email'] ?? '-') ?></span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Telepon:</strong><br>
                        <span class="text-muted"><?= esc($profile['phone'] ?? '-') ?></span>
                    </div>
                    <div class="col-12 mb-3">
                        <strong>Alamat:</strong><br>
                        <span class="text-muted"><?= esc($profile['address'] ?? '-') ?></span>
                    </div>
                </div>
                
                <div class="mt-4">
                    <strong>Kontak:</strong>
                    <div class="row mt-2">
                        <div class="col-md-6 mb-2">
                            <i class="fas fa-envelope me-2"></i>
                            <strong>Email:</strong> <?= esc($profile['email']) ?>
                        </div>
                        <div class="col-md-6 mb-2">
                            <i class="fas fa-phone me-2"></i>
                            <strong>Phone:</strong> <?= esc($profile['phone']) ?>
                        </div>
                        <div class="col-md-12 mb-2">
                            <i class="fas fa-map-marker-alt me-2"></i>
                            <strong>Address:</strong> <?= esc($profile['address']) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php else: ?>
<div class="alert alert-warning">
    <i class="fas fa-exclamation-triangle me-2"></i>
    Belum ada data profile. Silakan buat profile terlebih dahulu.
</div>
<?php endif; ?>

<style>
.profile-photo-admin {
    width: 200px;
    height: 200px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid #1e40af;
    box-shadow: 0 4px 15px rgba(15, 23, 42, 0.2);
}

.profile-photo-placeholder-admin {
    width: 200px;
    height: 200px;
    border-radius: 50%;
    background: #f8fafc;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    border: 4px solid #e2e8f0;
    margin: 0 auto;
}
</style>
<?= $this->endSection() ?>