<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<div class="container">
    <!-- Personal Profile Section -->
    <?php if (empty($biodata)): ?>
        <div class="card">
            <div class="card-body text-center" style="padding: 4rem 2rem;">
                <i class="fas fa-user-friends fa-4x text-muted mb-3"></i>
                <h4 class="text-muted">Belum ada data biodata</h4>
                <p class="text-muted">Data biodata akan ditampilkan di sini</p>
            </div>
        </div>
    <?php else: ?>
        <!-- Single Profile Layout for Personal Portfolio -->
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xl-6">
                <?php $bio = $biodata[0]; // Ambil biodata pertama (Dodi Iskandar) ?>
                <div class="card profile-card-main">
                    <div class="card-header text-center">
                        <?php if (!empty($bio['foto_profil'])): ?>
                            <img src="<?= base_url($bio['foto_profil']) ?>" 
                                 class="profile-image-main" 
                                 alt="<?= esc($bio['nama']) ?>"
                                 onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                            <div class="profile-image-placeholder-main" style="display: none;">
                                <span class="placeholder-initials">DI</span>
                            </div>
                        <?php else: ?>
                            <div class="profile-image-placeholder-main">
                                <span class="placeholder-initials">DI</span>
                            </div>
                        <?php endif; ?>
                        <h2 class="profile-name-main"><?= esc($bio['nama']) ?></h2>
                        <?php if (!empty($bio['tempat_lahir'])): ?>
                            <p class="profile-location"><?= esc($bio['tempat_lahir']) ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="card-body">
                        <?php if (!empty($bio['deskripsi'])): ?>
                            <div class="profile-description-main">
                                <h5 class="section-title">
                                    <i class="fas fa-user-circle me-2"></i>
                                    Tentang Saya
                                </h5>
                                <p><?= esc($bio['deskripsi']) ?></p>
                            </div>
                        <?php endif; ?>
                        
                        <div class="contact-info-main">
                            <h5 class="section-title">
                                <i class="fas fa-address-book me-2"></i>
                                Informasi Kontak
                            </h5>
                            
                            <div class="contact-grid">
                                <?php if (!empty($bio['email'])): ?>
                                    <div class="contact-item-main">
                                        <div class="contact-icon">
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                        <div class="contact-details">
                                            <div class="contact-label">Email</div>
                                            <div class="contact-value">
                                                <a href="mailto:<?= esc($bio['email']) ?>" class="contact-link">
                                                    <?= esc($bio['email']) ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($bio['no_hp'])): ?>
                                    <div class="contact-item-main">
                                        <div class="contact-icon">
                                            <i class="fas fa-phone"></i>
                                        </div>
                                        <div class="contact-details">
                                            <div class="contact-label">No. HP</div>
                                            <div class="contact-value">
                                                <a href="tel:<?= esc($bio['no_hp']) ?>" class="contact-link">
                                                    <?= esc($bio['no_hp']) ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($bio['alamat'])): ?>
                                    <div class="contact-item-main">
                                        <div class="contact-icon">
                                            <i class="fas fa-map-marker-alt"></i>
                                        </div>
                                        <div class="contact-details">
                                            <div class="contact-label">Alamat</div>
                                            <div class="contact-value"><?= esc($bio['alamat']) ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($bio['tanggal_lahir'])): ?>
                                    <div class="contact-item-main">
                                        <div class="contact-icon">
                                            <i class="fas fa-birthday-cake"></i>
                                        </div>
                                        <div class="contact-details">
                                            <div class="contact-label">Tanggal Lahir</div>
                                            <div class="contact-value">
                                                <?= date('d F Y', strtotime($bio['tanggal_lahir'])) ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($bio['jenis_kelamin'])): ?>
                                    <div class="contact-item-main">
                                        <div class="contact-icon">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <div class="contact-details">
                                            <div class="contact-label">Jenis Kelamin</div>
                                            <div class="contact-value">
                                                <span class="badge <?= $bio['jenis_kelamin'] == 'Laki-laki' ? 'badge-primary' : 'badge-danger' ?>">
                                                    <?= esc($bio['jenis_kelamin']) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($bio['agama'])): ?>
                                    <div class="contact-item-main">
                                        <div class="contact-icon">
                                            <i class="fas fa-pray"></i>
                                        </div>
                                        <div class="contact-details">
                                            <div class="contact-label">Agama</div>
                                            <div class="contact-value"><?= esc($bio['agama']) ?></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-footer text-center">
                        <div class="contact-actions">
                            <a href="mailto:<?= esc($bio['email']) ?>" class="contact-button-main">
                                <i class="fas fa-envelope me-2"></i>
                                Kirim Email
                            </a>
                            <a href="tel:<?= esc($bio['no_hp']) ?>" class="contact-button-secondary">
                                <i class="fas fa-phone me-2"></i>
                                Telepon
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Links Section -->
        <div class="row mt-5">
            <div class="col-lg-4">
                <div class="quick-link-card">
                    <div class="quick-link-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <h5>Aktivitas Harian</h5>
                    <p>Lihat dokumentasi kegiatan dan proyek yang sedang dikerjakan</p>
                    <a href="<?= base_url('activities') ?>" class="btn btn-outline-primary">
                        Lihat Aktivitas <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="quick-link-card">
                    <div class="quick-link-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <h5>Riwayat Pendidikan</h5>
                    <p>Jelajahi perjalanan akademis dan pencapaian pendidikan</p>
                    <a href="<?= base_url('education') ?>" class="btn btn-outline-primary">
                        Lihat Pendidikan <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="quick-link-card">
                    <div class="quick-link-icon">
                        <i class="fas fa-home"></i>
                    </div>
                    <h5>Kembali ke Beranda</h5>
                    <p>Kembali ke halaman utama untuk melihat overview portfolio</p>
                    <a href="<?= base_url('/') ?>" class="btn btn-outline-primary">
                        Ke Beranda <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
/* Personal Portfolio Biodata Styles */
.profile-card-main {
    border-radius: 24px;
    box-shadow: var(--shadow-xl);
    border: 2px solid var(--border-color);
    overflow: hidden;
    margin-bottom: 3rem;
}

.profile-card-main:hover {
    transform: translateY(-8px);
    box-shadow: 0 25px 50px rgba(37, 99, 235, 0.2);
    border-color: var(--accent-color);
}

.profile-image-main {
    width: 220px;
    height: 220px;
    border-radius: 50%;
    object-fit: cover;
    border: 6px solid var(--accent-color);
    margin: 0 auto 2rem;
    display: block;
    box-shadow: var(--shadow-xl);
    transition: all 0.3s ease;
}

.profile-image-main:hover {
    transform: scale(1.05);
    box-shadow: var(--shadow-2xl);
}

.profile-image-placeholder-main {
    width: 220px;
    height: 220px;
    border-radius: 50%;
    background: var(--gradient-accent);
    border: 6px solid var(--primary-color);
    margin: 0 auto 2rem;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    box-shadow: var(--shadow-xl);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.profile-image-placeholder-main::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: conic-gradient(from 0deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    animation: rotate 8s linear infinite;
}

.profile-image-placeholder-main .placeholder-initials {
    font-size: 4rem;
    font-weight: 900;
    position: relative;
    z-index: 2;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
}

.profile-image-placeholder-main:hover {
    transform: scale(1.05);
    box-shadow: var(--shadow-2xl);
}

@keyframes rotate {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.profile-name-main {
    font-size: 2.5rem;
    font-weight: 800;
    color: var(--primary-color);
    margin-bottom: 0.5rem;
    text-align: center;
}

.profile-location {
    color: var(--text-secondary);
    font-size: 1.2rem;
    font-weight: 600;
    text-align: center;
    margin-bottom: 0;
}

.profile-description-main {
    margin-bottom: 3rem;
    text-align: center;
}

.profile-description-main p {
    font-size: 1.1rem;
    line-height: 1.8;
    color: var(--text-secondary);
}

.section-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--primary-color);
    margin-bottom: 2rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.contact-info-main {
    margin-bottom: 2rem;
}

.contact-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.contact-item-main {
    display: flex;
    align-items: center;
    padding: 1.5rem;
    background: var(--light-bg);
    border-radius: 16px;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.contact-item-main:hover {
    background: var(--gradient-accent);
    color: white;
    transform: translateY(-4px);
    border-color: var(--primary-color);
    box-shadow: var(--shadow-lg);
}

.contact-icon {
    width: 60px;
    height: 60px;
    background: var(--gradient-accent);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1.5rem;
    font-size: 1.5rem;
    color: white;
    box-shadow: var(--shadow-md);
    flex-shrink: 0;
}

.contact-item-main:hover .contact-icon {
    background: rgba(255, 255, 255, 0.2);
    color: white;
}

.contact-details {
    flex: 1;
}

.contact-label {
    font-weight: 700;
    color: var(--text-secondary);
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.75px;
}

.contact-item-main:hover .contact-label {
    color: rgba(255, 255, 255, 0.9);
}

.contact-value {
    font-weight: 600;
    color: var(--text-primary);
    font-size: 1.1rem;
}

.contact-item-main:hover .contact-value {
    color: white;
}

.contact-link {
    color: inherit;
    text-decoration: none;
    transition: all 0.3s ease;
}

.contact-link:hover {
    text-decoration: underline;
}

.contact-actions {
    display: flex;
    gap: 1.5rem;
    justify-content: center;
    flex-wrap: wrap;
}

.contact-button-main,
.contact-button-secondary {
    padding: 1rem 2rem;
    border-radius: 12px;
    font-weight: 700;
    text-decoration: none;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 1.1rem;
}

.contact-button-main {
    background: var(--gradient-accent);
    color: white;
    box-shadow: var(--shadow-lg);
}

.contact-button-main:hover {
    transform: translateY(-3px);
    box-shadow: var(--shadow-xl);
    color: white;
}

.contact-button-secondary {
    background: transparent;
    color: var(--primary-color);
    border: 2px solid var(--primary-color);
}

.contact-button-secondary:hover {
    background: var(--primary-color);
    color: white;
    transform: translateY(-2px);
}

/* Quick Links Section */
.quick-link-card {
    background: var(--card-bg);
    border: 2px solid var(--border-color);
    border-radius: 20px;
    padding: 2.5rem;
    text-align: center;
    transition: all 0.3s ease;
    height: 100%;
    box-shadow: var(--shadow-lg);
}

.quick-link-card:hover {
    transform: translateY(-6px);
    box-shadow: var(--shadow-xl);
    border-color: var(--accent-color);
}

.quick-link-icon {
    width: 80px;
    height: 80px;
    background: var(--gradient-accent);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 2rem;
    font-size: 2rem;
    color: white;
    box-shadow: var(--shadow-lg);
}

.quick-link-card h5 {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 1rem;
}

.quick-link-card p {
    color: var(--text-secondary);
    line-height: 1.7;
    margin-bottom: 2rem;
}

/* Responsive Design */
@media (max-width: 768px) {
    .profile-name-main {
        font-size: 2rem;
    }
    
    .profile-image-main,
    .profile-image-placeholder-main {
        width: 180px;
        height: 180px;
    }
    
    .placeholder-initials {
        font-size: 3rem !important;
    }
    
    .contact-grid {
        grid-template-columns: 1fr;
    }
    
    .contact-actions {
        flex-direction: column;
        align-items: center;
    }
    
    .contact-button-main,
    .contact-button-secondary {
        width: 100%;
        justify-content: center;
    }
    
    .quick-link-card {
        padding: 2rem;
        margin-bottom: 2rem;
    }
}

@media (max-width: 576px) {
    .section-title {
        font-size: 1.25rem;
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .contact-item-main {
        padding: 1rem;
    }
    
    .contact-icon {
        width: 50px;
        height: 50px;
        font-size: 1.25rem;
        margin-right: 1rem;
    }
    
    .profile-image-main,
    .profile-image-placeholder-main {
        width: 160px;
        height: 160px;
    }
    
    .placeholder-initials {
        font-size: 2.5rem !important;
    }
}
</style>

<?= $this->endSection() ?>