<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<div class="container">
    <!-- Search and Filter Section -->
    <div class="search-filter-card">
        <div class="card-body">
            <form method="get" action="<?= base_url('education') ?>">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fas fa-search me-2"></i>
                            Cari Pendidikan
                        </label>
                        <input type="text" name="search" class="form-control" 
                               placeholder="Cari nama sekolah, jurusan..." 
                               value="<?= esc($search) ?>">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">
                            <i class="fas fa-graduation-cap me-2"></i>
                            Filter Jenjang
                        </label>
                        <select name="filter_jenjang" class="form-control">
                            <option value="">Semua Jenjang</option>
                            <option value="SD" <?= $filter_jenjang == 'SD' ? 'selected' : '' ?>>SD</option>
                            <option value="SMP" <?= $filter_jenjang == 'SMP' ? 'selected' : '' ?>>SMP</option>
                            <option value="SMA" <?= $filter_jenjang == 'SMA' ? 'selected' : '' ?>>SMA</option>
                            <option value="S1" <?= $filter_jenjang == 'S1' ? 'selected' : '' ?>>S1</option>
                            <option value="S2" <?= $filter_jenjang == 'S2' ? 'selected' : '' ?>>S2</option>
                            <option value="S3" <?= $filter_jenjang == 'S3' ? 'selected' : '' ?>>S3</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search"></i>
                            </button>
                            <a href="<?= base_url('education') ?>" class="btn btn-secondary">
                                <i class="fas fa-refresh"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Sorting Options -->
    <div class="sorting-card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted fw-bold">
                    <i class="fas fa-sort me-2"></i>
                    Urutkan berdasarkan:
                </small>
                <div class="d-flex gap-2">
                    <a href="<?= base_url('education?sort_by=nama_sekolah&sort_order=' . ($sort_by == 'nama_sekolah' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>" 
                       class="btn btn-sm btn-outline-primary">
                        Sekolah <?= $sort_by == 'nama_sekolah' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
                    </a>
                    <a href="<?= base_url('education?sort_by=jenjang&sort_order=' . ($sort_by == 'jenjang' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>" 
                       class="btn btn-sm btn-outline-primary">
                        Jenjang <?= $sort_by == 'jenjang' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
                    </a>
                    <a href="<?= base_url('education?sort_by=tahun_mulai&sort_order=' . ($sort_by == 'tahun_mulai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>" 
                       class="btn btn-sm btn-outline-primary">
                        Tahun Mulai <?= $sort_by == 'tahun_mulai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Education Cards -->
    <?php if (empty($educations)): ?>
        <div class="empty-state">
            <i class="fas fa-graduation-cap"></i>
            <h4>Belum ada data pendidikan</h4>
            <p>Data riwayat pendidikan akan ditampilkan di sini ketika sudah tersedia</p>
        </div>
    <?php else: ?>
        <div class="education-grid">
            <?php foreach($educations as $edu): ?>
                <div class="education-card-wrapper">
                    <div class="card education-card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-start">
                                <div style="flex: 1;">
                                    <span class="badge badge-primary mb-2"><?= esc($edu['jenjang']) ?></span>
                                    <h5 class="education-title"><?= esc($edu['nama_sekolah']) ?></h5>
                                    <?php if (!empty($edu['jurusan'])): ?>
                                        <p class="text-muted mb-0"><?= esc($edu['jurusan']) ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card-body" style="flex: 1;">
                            <div class="education-period mb-3">
                                <i class="fas fa-calendar-alt me-2"></i>
                                <?= $edu['tahun_mulai'] ?> - <?= $edu['tahun_selesai'] ?>
                                <span class="ms-2 text-muted">
                                    (<?= ($edu['tahun_selesai'] - $edu['tahun_mulai']) ?> tahun)
                                </span>
                            </div>
                            
                            <?php if (!empty($edu['deskripsi'])): ?>
                                <p class="education-description"><?= esc($edu['deskripsi']) ?></p>
                            <?php endif; ?>
                            
                            <?php if (!empty($edu['ipk']) && $edu['ipk'] > 0): ?>
                                <div class="mt-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-muted">IPK/Nilai:</span>
                                        <span class="badge badge-success">
                                            <?= number_format($edu['ipk'], 2) ?>
                                        </span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="card-footer">
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">
                                    <i class="fas fa-clock me-1"></i>
                                    <?= date('d/m/Y H:i', strtotime($edu['created_at'])) ?>
                                </small>
                                <div>
                                    <?php if (!empty($edu['ipk']) && $edu['ipk'] > 0): ?>
                                        <?php if ($edu['ipk'] >= 3.5): ?>
                                            <span class="badge badge-success">Cum Laude</span>
                                        <?php elseif ($edu['ipk'] >= 3.0): ?>
                                            <span class="badge badge-warning">Baik</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Pagination -->
        <?php if ($pager->getPageCount() > 1): ?>
            <div class="pagination-wrapper">
                <?= $pager->links() ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>