<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<!-- Hero Section -->
<div class="hero-wrap">
    <div class="container hero-grid">
        <div class="hero-copy">
            <div class="hero-eyebrow">Portfolio Pribadi</div>
            <h1 class="hero-title">
                Halo, Saya <span style="color: rgba(255,255,255,0.95);">Dodi Iskandar</span>
            </h1>
            <h2 class="hero-subtitle">Pengembang Web & Mahasiswa</h2>
            <p class="hero-desc">
                Pengembang web yang passionate dengan keahlian dalam teknologi modern. 
                Saya menciptakan solusi digital yang inovatif dan terus mengembangkan 
                kemampuan dalam programming dan pengembangan perangkat lunak.
            </p>
            <div class="hero-actions">
                <a href="<?= base_url('biodata') ?>" class="btn-solid">
                    <i class="fas fa-user me-2"></i>
                    Lihat Profil
                </a>
                <a href="<?= base_url('activities') ?>" class="btn-ghost">
                    <i class="fas fa-briefcase me-2"></i>
                    Aktivitas Saya
                </a>
                <a href="<?= base_url('education') ?>" class="btn-soft">
                    <i class="fas fa-graduation-cap me-2"></i>
                    Pendidikan
                </a>
            </div>
        </div>
        <div class="hero-visual">
            <div class="hero-orb">
                <?php if ($profile && !empty($profile['photo'])): ?>
                    <img src="<?= base_url('uploads/profile/' . $profile['photo']) ?>" 
                         alt="Dodi Iskandar" 
                         class="hero-profile-image"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                    <span class="hero-initials" style="display: none;">DI</span>
                <?php else: ?>
                    <!-- Check if biodata has photo -->
                    <?php 
                    $db = \Config\Database::connect();
                    $query = $db->query("SELECT foto_profil FROM biodata WHERE nama = 'Dodi Iskandar' LIMIT 1");
                    $biodata = $query->getRowArray();
                    ?>
                    <?php if ($biodata && !empty($biodata['foto_profil'])): ?>
                        <img src="<?= base_url($biodata['foto_profil']) ?>" 
                             alt="Dodi Iskandar" 
                             class="hero-profile-image"
                             onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                        <span class="hero-initials" style="display: none;">DI</span>
                    <?php else: ?>
                        <span class="hero-initials">DI</span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Features Section -->
<div class="features-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Jelajahi Portfolio Saya</h2>
            <p class="section-subtitle">Temukan berbagai aspek dari perjalanan profesional dan akademis saya</p>
        </div>
        
        <div class="features-grid">
            <div class="feature-card feature-card-primary">
                <div class="feature-icon feature-icon-primary">
                    <i class="fas fa-briefcase"></i>
                </div>
                <div class="feature-content">
                    <h3 class="feature-title">Aktivitas Harian</h3>
                    <p class="feature-description">
                        Dokumentasi lengkap dari proyek-proyek yang sedang dikerjakan, 
                        galeri foto aktivitas, dan pembaruan video dari rutinitas harian sebagai pengembang.
                    </p>
                    <div class="feature-stats">
                        <div class="stat-item">
                            <span class="stat-number">50+</span>
                            <span class="stat-label">Aktivitas</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">20+</span>
                            <span class="stat-label">Proyek</span>
                        </div>
                    </div>
                    <a href="<?= base_url('activities') ?>" class="feature-button">
                        Lihat Aktivitas
                        <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>

            <div class="feature-card feature-card-secondary">
                <div class="feature-icon feature-icon-secondary">
                    <i class="fas fa-user"></i>
                </div>
                <div class="feature-content">
                    <h3 class="feature-title">Profil Pribadi</h3>
                    <p class="feature-description">
                        Informasi lengkap tentang latar belakang, keahlian teknis, 
                        pengalaman freelance, dan semua keterampilan yang telah dikuasai.
                    </p>
                    <div class="feature-stats">
                        <div class="stat-item">
                            <span class="stat-number">5+</span>
                            <span class="stat-label">Keahlian</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">2+</span>
                            <span class="stat-label">Tahun</span>
                        </div>
                    </div>
                    <a href="<?= base_url('biodata') ?>" class="feature-button">
                        Lihat Profil
                        <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>

            <div class="feature-card feature-card-tertiary">
                <div class="feature-icon feature-icon-tertiary">
                    <i class="fas fa-graduation-cap"></i>
                </div>
                <div class="feature-content">
                    <h3 class="feature-title">Riwayat Pendidikan</h3>
                    <p class="feature-description">
                        Perjalanan akademis dari tingkat dasar hingga perguruan tinggi, 
                        pencapaian akademik, dan fokus bidang studi yang digeluti.
                    </p>
                    <div class="feature-stats">
                        <div class="stat-item">
                            <span class="stat-number">4</span>
                            <span class="stat-label">Jenjang</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">3.8</span>
                            <span class="stat-label">IPK</span>
                        </div>
                    </div>
                    <a href="<?= base_url('education') ?>" class="feature-button">
                        Lihat Pendidikan
                        <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Contact CTA Section -->
<div class="cta-section">
    <div class="container">
        <div class="cta-card">
            <div class="cta-content">
                <h2 class="cta-title">Mari Berkolaborasi</h2>
                <p class="cta-description">
                    Siap untuk bekerja sama? Mari diskusikan proyek Anda dan wujudkan ide-ide kreatif menjadi kenyataan.
                </p>
                <div class="cta-actions">
                    <a href="mailto:dodiiskandar270503@gmail.com" class="cta-button cta-button-primary">
                        <i class="fas fa-envelope me-2"></i>
                        Kirim Email
                    </a>
                    <a href="tel:085210357970" class="cta-button cta-button-secondary">
                        <i class="fas fa-phone me-2"></i>
                        Hubungi Sekarang
                    </a>
                </div>
            </div>
            <div class="cta-visual">
                <div class="cta-decoration">
                    <i class="fas fa-code"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Hero Profile Image */
.hero-profile-image {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    object-fit: cover;
    position: relative;
    z-index: 2;
}

.hero-initials {
    font-size: 3.5rem;
    font-weight: 900;
    position: relative;
    z-index: 2;
}

/* Features Section */
.features-section {
    padding: 8rem 0;
    background: var(--light-bg);
    position: relative;
}

.section-header {
    text-align: center;
    margin-bottom: 5rem;
}

.section-title {
    font-size: 3rem;
    font-weight: 900;
    color: var(--text-primary);
    margin-bottom: 1.5rem;
    line-height: 1.2;
}

.section-subtitle {
    font-size: 1.3rem;
    color: var(--text-secondary);
    max-width: 600px;
    margin: 0 auto;
    line-height: 1.6;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 3rem;
    margin-bottom: 2rem;
}

.feature-card {
    background: var(--card-bg);
    border: 2px solid var(--border-color);
    border-radius: 32px;
    padding: 3rem;
    box-shadow: var(--shadow-lg);
    transition: all 0.4s ease;
    position: relative;
    overflow: hidden;
    height: 100%;
    display: flex;
    flex-direction: column;
}

.feature-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: var(--gradient-accent);
    transform: scaleX(0);
    transition: transform 0.4s ease;
}

.feature-card:hover::before {
    transform: scaleX(1);
}

.feature-card:hover {
    transform: translateY(-12px);
    box-shadow: var(--shadow-2xl);
    border-color: var(--accent-color);
}

.feature-card-primary:hover {
    border-color: var(--primary-color);
}

.feature-card-secondary:hover {
    border-color: var(--success-color);
}

.feature-card-tertiary:hover {
    border-color: var(--warning-color);
}

.feature-icon {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 2rem;
    font-size: 2rem;
    color: white;
    box-shadow: var(--shadow-lg);
    transition: all 0.3s ease;
}

.feature-card:hover .feature-icon {
    transform: scale(1.1);
    box-shadow: var(--shadow-xl);
}

.feature-icon-primary {
    background: var(--gradient-accent);
}

.feature-icon-secondary {
    background: linear-gradient(135deg, var(--success-color) 0%, #059669 100%);
}

.feature-icon-tertiary {
    background: linear-gradient(135deg, var(--warning-color) 0%, #d97706 100%);
}

.feature-content {
    flex: 1;
    display: flex;
    flex-direction: column;
}

.feature-title {
    font-size: 1.75rem;
    font-weight: 800;
    color: var(--text-primary);
    margin-bottom: 1.5rem;
    line-height: 1.3;
}

.feature-description {
    color: var(--text-secondary);
    line-height: 1.7;
    margin-bottom: 2rem;
    font-size: 1.1rem;
    flex: 1;
}

.feature-stats {
    display: flex;
    gap: 2rem;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: #f8fafc;
    border-radius: 16px;
    border-left: 4px solid var(--accent-color);
}

.stat-item {
    text-align: center;
}

.stat-number {
    display: block;
    font-size: 1.75rem;
    font-weight: 900;
    color: var(--primary-color);
    line-height: 1;
}

.stat-label {
    font-size: 0.9rem;
    color: var(--text-secondary);
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.feature-button {
    background: var(--gradient-accent);
    color: white;
    padding: 1rem 2rem;
    border-radius: 16px;
    text-decoration: none;
    font-weight: 700;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    box-shadow: var(--shadow-colored);
    margin-top: auto;
}

.feature-button:hover {
    transform: translateY(-3px);
    box-shadow: var(--shadow-xl);
    color: white;
}

/* CTA Section */
.cta-section {
    padding: 6rem 0;
    background: var(--gradient-bg);
}

.cta-card {
    background: var(--gradient-hero);
    border-radius: 32px;
    padding: 4rem;
    color: white;
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 4rem;
    align-items: center;
    box-shadow: var(--shadow-2xl);
    position: relative;
    overflow: hidden;
}

.cta-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="ctaGrain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="0.5" fill="rgba(255,255,255,0.1)"/><circle cx="75" cy="75" r="0.5" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23ctaGrain)"/></svg>');
    opacity: 0.4;
}

.cta-content {
    position: relative;
    z-index: 2;
}

.cta-title {
    font-size: 2.5rem;
    font-weight: 900;
    margin-bottom: 1.5rem;
    line-height: 1.2;
}

.cta-description {
    font-size: 1.2rem;
    line-height: 1.7;
    margin-bottom: 2.5rem;
    opacity: 0.9;
}

.cta-actions {
    display: flex;
    gap: 1.5rem;
    flex-wrap: wrap;
}

.cta-button {
    padding: 1.25rem 2.5rem;
    border-radius: 16px;
    text-decoration: none;
    font-weight: 700;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 1.1rem;
    border: 2px solid transparent;
}

.cta-button-primary {
    background: rgba(255, 255, 255, 0.25);
    color: white;
    border-color: rgba(255, 255, 255, 0.4);
    backdrop-filter: blur(15px);
}

.cta-button-primary:hover {
    background: rgba(255, 255, 255, 0.35);
    transform: translateY(-3px);
    color: white;
    box-shadow: var(--shadow-xl);
}

.cta-button-secondary {
    background: transparent;
    color: white;
    border-color: rgba(255, 255, 255, 0.5);
}

.cta-button-secondary:hover {
    background: rgba(255, 255, 255, 0.15);
    color: white;
    transform: translateY(-3px);
}

.cta-visual {
    display: flex;
    justify-content: center;
    align-items: center;
    position: relative;
    z-index: 2;
}

.cta-decoration {
    width: 120px;
    height: 120px;
    background: rgba(255, 255, 255, 0.15);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 3rem;
    backdrop-filter: blur(15px);
    border: 2px solid rgba(255, 255, 255, 0.3);
    animation: float 6s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

/* Responsive Design */
@media (max-width: 1200px) {
    .features-grid {
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        gap: 2rem;
    }
}

@media (max-width: 992px) {
    .section-title {
        font-size: 2.5rem;
    }
    
    .cta-card {
        grid-template-columns: 1fr;
        text-align: center;
        gap: 2rem;
        padding: 3rem;
    }
}

@media (max-width: 768px) {
    .features-section {
        padding: 6rem 0;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
        gap: 2rem;
    }
    
    .feature-card {
        padding: 2rem;
    }
    
    .section-title {
        font-size: 2rem;
    }
    
    .section-subtitle {
        font-size: 1.1rem;
    }
    
    .cta-title {
        font-size: 2rem;
    }
    
    .cta-actions {
        flex-direction: column;
        align-items: center;
    }
    
    .cta-button {
        width: 100%;
        justify-content: center;
    }
    
    .feature-stats {
        gap: 1rem;
    }
}

@media (max-width: 576px) {
    .feature-card {
        padding: 1.5rem;
    }
    
    .cta-card {
        padding: 2rem;
    }
    
    .feature-icon {
        width: 60px;
        height: 60px;
        font-size: 1.5rem;
    }
}
</style>

<?= $this->endSection() ?>