<footer class="footer-modern">
    <div class="container">
        <div class="footer-content">
            <div class="footer-main">
                <div class="footer-brand">
                    <h3 class="footer-brand-text">Dodi Iskandar</h3>
                    <p class="footer-tagline">Web Developer & Student</p>
                </div>
                <div class="footer-links">
                    <div class="footer-section">
                        <h4 class="footer-section-title">Navigasi</h4>
                        <ul class="footer-nav">
                            <li><a href="<?= base_url('/') ?>">Beranda</a></li>
                            <li><a href="<?= base_url('biodata') ?>">Biodata</a></li>
                            <li><a href="<?= base_url('activities') ?>">Aktivitas</a></li>
                            <li><a href="<?= base_url('education') ?>">Pendidikan</a></li>
                        </ul>
                    </div>
                    <div class="footer-section">
                        <h4 class="footer-section-title">Kontak</h4>
                        <ul class="footer-contact">
                            <li>
                                <i class="fas fa-envelope"></i>
                                <span>dodiiskandar270503@gmail.com</span>
                            </li>
                            <li>
                                <i class="fas fa-phone"></i>
                                <span>085210357970</span>
                            </li>
                            <li>
                                <i class="fas fa-map-marker-alt"></i>
                                <span>Tangerang, Jalan Raya Benda</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="footer-copyright">
                    <p>&copy; 2025 Dodi Iskandar. All rights reserved.</p>
                    <p class="footer-university">Universitas Yatsi Madani</p>
                </div>
                <div class="footer-admin">
                    <a href="<?= base_url('admin/login') ?>" class="footer-admin-link" title="Login Admin">
                        <i class="fas fa-shield-alt"></i>
                        <span>Admin Panel</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</footer>

<style>
.footer-modern {
    background: var(--gradient-hero);
    color: white;
    padding: 4rem 0 2rem;
    margin-top: 6rem;
    position: relative;
    overflow: hidden;
}

.footer-modern::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="footerGrain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="0.5" fill="rgba(255,255,255,0.1)"/><circle cx="75" cy="75" r="0.5" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23footerGrain)"/></svg>');
    opacity: 0.4;
}

.footer-content {
    position: relative;
    z-index: 2;
}

.footer-main {
    display: grid;
    grid-template-columns: 1fr 2fr;
    gap: 4rem;
    margin-bottom: 3rem;
    padding-bottom: 3rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.2);
}

.footer-brand-text {
    font-size: 2rem;
    font-weight: 900;
    margin-bottom: 0.5rem;
    color: white;
}

.footer-tagline {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    font-weight: 500;
}

.footer-links {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 3rem;
}

.footer-section-title {
    font-size: 1.25rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    color: white;
}

.footer-nav,
.footer-contact {
    list-style: none;
    padding: 0;
    margin: 0;
}

.footer-nav li,
.footer-contact li {
    margin-bottom: 0.75rem;
}

.footer-nav a {
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    display: inline-block;
}

.footer-nav a:hover {
    color: white;
    transform: translateX(4px);
}

.footer-contact li {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    color: rgba(255, 255, 255, 0.8);
    font-weight: 500;
}

.footer-contact i {
    width: 16px;
    color: rgba(255, 255, 255, 0.6);
}

.footer-bottom {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 2rem;
}

.footer-copyright p {
    margin: 0;
    color: rgba(255, 255, 255, 0.7);
    font-size: 0.9rem;
}

.footer-university {
    font-weight: 600;
    color: rgba(255, 255, 255, 0.9) !important;
}

.footer-admin-link {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: rgba(255, 255, 255, 0.15);
    color: white;
    border-radius: 12px;
    text-decoration: none;
    font-size: 0.9rem;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
}

.footer-admin-link:hover {
    background: rgba(255, 255, 255, 0.25);
    color: white;
    text-decoration: none;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

@media (max-width: 992px) {
    .footer-main {
        grid-template-columns: 1fr;
        gap: 2rem;
        text-align: center;
    }
    
    .footer-links {
        grid-template-columns: 1fr;
        gap: 2rem;
    }
}

@media (max-width: 768px) {
    .footer-modern {
        padding: 3rem 0 1.5rem;
        margin-top: 4rem;
    }
    
    .footer-bottom {
        flex-direction: column;
        text-align: center;
        gap: 1rem;
    }
    
    .footer-brand-text {
        font-size: 1.5rem;
    }
}
</style>