<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal Data Pribadi - Dodi Iskandar</title>
    <link rel="stylesheet" href="<?= base_url('css/custom.css') ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?= $this->include('layout/navbar') ?>
    
    <?php 
    $uri = service('uri');
    $segment1 = $uri->getSegment(1) ?: 'home';
    $isHome = ($segment1 === 'home' || $segment1 === '');
    ?>
    
    <?php if (!$isHome): ?>
        <?= $this->include('layout/page_header') ?>
    <?php endif; ?>

    <div class="main-container">
        <section id="main-content" class="content-section">
            <?= $this->renderSection('content') ?>
        </section>
    </div>

    <!-- Floating Admin Login Button -->
    <div class="floating-admin-btn" id="floatingAdminBtn">
        <a href="<?= base_url('admin/login') ?>" class="btn-floating" title="Login Admin">
            <i class="fas fa-shield-alt"></i>
        </a>
        <div class="floating-tooltip">Login Admin</div>
    </div>

    <?= $this->include('layout/footer') ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Navbar scroll effect
            var $navbar = $('.navbar-custom');
            var $window = $(window);
            
            $window.scroll(function() {
                if ($window.scrollTop() > 50) {
                    $navbar.addClass('scrolled');
                } else {
                    $navbar.removeClass('scrolled');
                }
            });
            
            // Mobile navbar toggle
            $('#navToggler').click(function() {
                $('#mobileNav').toggleClass('show');
                $(this).toggleClass('active');
            });
            
            // Close mobile menu when clicking nav links
            $('#mobileNav .nav-link').click(function() {
                $('#mobileNav').removeClass('show');
                $('#navToggler').removeClass('active');
            });
            
            // Close mobile menu when clicking outside
            $(document).click(function(e) {
                if (!$(e.target).closest('.navbar-custom').length) {
                    $('#mobileNav').removeClass('show');
                    $('#navToggler').removeClass('active');
                }
            });
            
            // Floating admin button functionality
            var $floatingBtn = $('#floatingAdminBtn');
            
            // Show/hide floating button based on scroll
            $window.scroll(function() {
                if ($window.scrollTop() > 300) {
                    $floatingBtn.addClass('show');
                } else {
                    $floatingBtn.removeClass('show');
                }
            });
            
            // Tooltip functionality
            $floatingBtn.hover(
                function() {
                    $(this).find('.floating-tooltip').addClass('show');
                },
                function() {
                    $(this).find('.floating-tooltip').removeClass('show');
                }
            );
            
            // Smooth scrolling for anchor links
            $('a[href^="#"]').click(function(e) {
                var target = $(this.getAttribute('href'));
                if (target.length) {
                    e.preventDefault();
                    $('html, body').animate({
                        scrollTop: target.offset().top - 100
                    }, 800);
                }
            });
            
            // Card animations
            function animateCards() {
                $('.card').each(function(index) {
                    var $card = $(this);
                    setTimeout(function() {
                        $card.addClass('animate-in');
                    }, index * 100);
                });
            }
            
            // Initial animation
            setTimeout(animateCards, 300);
            
            // Form enhancements
            $('.form-control').on('focus', function() {
                $(this).parent().addClass('focused');
            }).on('blur', function() {
                $(this).parent().removeClass('focused');
            });
        });
    </script>
    
    <style>
        /* Animation styles */
        .card {
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.6s ease;
        }
        
        .card.animate-in {
            opacity: 1;
            transform: translateY(0);
        }
        
        /* Loading states */
        .btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }
        
        /* Focus states */
        .focused .form-control {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }
        
        /* Smooth transitions */
        * {
            transition: color 0.3s ease, background-color 0.3s ease, border-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
        }
    </style>
</body>
</html>