<!DOCTYPE html>
<html>
<head>
    <title>CodeIgniter Upload Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .info { background: #e3f2fd; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .result { background: #f5f5f5; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .success { background: #e8f5e8; color: #2e7d32; }
        .error { background: #ffebee; color: #c62828; }
        button { background: #1976d2; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        button:hover { background: #1565c0; }
        input[type="file"] { margin: 10px 0; }
    </style>
</head>
<body>
    <h1>CodeIgniter Upload Test</h1>
    
    <div class="info">
        <h3>System Information:</h3>
        <p><strong>Upload Directory:</strong> <?= $uploadDir ?></p>
        <p><strong>Directory Exists:</strong> <?= $dirExists ? 'Yes' : 'No' ?></p>
        <p><strong>Directory Writable:</strong> <?= $dirWritable ? 'Yes' : 'No' ?></p>
        <p><strong>File Uploads Enabled:</strong> <?= $fileUploads ? 'Yes' : 'No' ?></p>
        <p><strong>Max Upload Size:</strong> <?= $maxUpload ?></p>
        <p><strong>Max Post Size:</strong> <?= $maxPost ?></p>
    </div>
    
    <form id="uploadForm" enctype="multipart/form-data">
        <h3>Test Upload:</h3>
        <input type="file" name="photo" accept="image/*" required>
        <br>
        <button type="submit">Upload File</button>
    </form>
    
    <div id="result" class="result" style="display: none;"></div>
    
    <script>
    document.getElementById('uploadForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const resultDiv = document.getElementById('result');
        
        resultDiv.innerHTML = 'Uploading...';
        resultDiv.style.display = 'block';
        resultDiv.className = 'result';
        
        fetch('<?= base_url('test-upload/upload') ?>', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            resultDiv.className = 'result ' + (data.success ? 'success' : 'error');
            
            let html = '<h3>Upload Result:</h3>';
            html += '<p><strong>Status:</strong> ' + (data.success ? 'SUCCESS' : 'FAILED') + '</p>';
            html += '<p><strong>Message:</strong> ' + data.message + '</p>';
            
            if (data.details) {
                html += '<h4>Details:</h4>';
                for (const [key, value] of Object.entries(data.details)) {
                    html += '<p><strong>' + key + ':</strong> ' + value + '</p>';
                }
            }
            
            if (data.success && data.details.web_path) {
                html += '<h4>Uploaded Image:</h4>';
                html += '<img src="' + data.details.web_path + '" style="max-width: 200px; border: 2px solid green;">';
            }
            
            resultDiv.innerHTML = html;
        })
        .catch(error => {
            resultDiv.className = 'result error';
            resultDiv.innerHTML = '<h3>Error:</h3><p>' + error.message + '</p>';
        });
    });
    </script>
</body>
</html>