<?php

/**
 * Setup Admin System
 * 
 * Script untuk menjalankan migration dan seeder untuk sistem admin
 * Jalankan file ini sekali untuk setup database admin
 */

require_once 'vendor/autoload.php';

// Load CodeIgniter
$app = require_once FCPATH . '../app/Config/Paths.php';
$app = new \CodeIgniter\CodeIgniter($app);
$app->initialize();

echo "=== Setup Admin System ===\n\n";

try {
    // Run migration
    echo "1. Running migration for admins table...\n";
    $migrate = \Config\Services::migrations();
    $migrate->latest();
    echo "   ✓ Migration completed successfully\n\n";
    
    // Run seeder
    echo "2. Running seeder for default admin...\n";
    $seeder = \Config\Database::seeder();
    $seeder->call('AdminSeeder');
    echo "   ✓ Default admin created successfully\n\n";
    
    echo "=== Setup Completed Successfully! ===\n\n";
    echo "Default Admin Login:\n";
    echo "Username: admin\n";
    echo "Password: admin123\n";
    echo "Email: admin@example.com\n\n";
    echo "You can now access admin panel at: " . base_url('admin/login') . "\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "\nPlease check your database configuration in app/Config/Database.php\n";
}