<?php

// Simple test using CodeIgniter's spark command
echo "=== BIODATA ADMIN FUNCTIONALITY TEST ===\n";
echo "Testing basic database operations...\n\n";

// Test 1: Check if we can connect to database
echo "1. Testing database connection via spark...\n";
system('php spark migrate:status');

echo "\n2. Testing if biodata table exists and has data...\n";
system('php spark db:table biodata');

echo "\n=== MANUAL VERIFICATION STEPS ===\n";
echo "To verify the biodata edit functionality:\n";
echo "1. Open browser and go to: http://localhost/iskandarwebprogram/admin/login\n";
echo "2. Login with: username=admin, password=admin123\n";
echo "3. Go to: http://localhost/iskandarwebprogram/admin/biodata\n";
echo "4. Click the edit button (pencil icon) on any biodata record\n";
echo "5. The URL should be: /admin/biodata/edit/{id}\n";
echo "6. You should see the edit form with populated data\n\n";

echo "If you get a 404 error, the issue might be:\n";
echo "- Web server not running (start Apache/Nginx)\n";
echo "- .htaccess file issues\n";
echo "- Route caching (clear cache)\n";
echo "- Admin session expired (login again)\n\n";

echo "=== ROUTE VERIFICATION ===\n";
echo "Current route configuration:\n";
echo "- Biodata edit: GET /admin/biodata/edit/([0-9]+)\n";
echo "- Activities edit: GET /admin/activities/([0-9]+)/edit\n";
echo "- Education edit: GET /admin/education/([0-9]+)/edit\n\n";

echo "The biodata edit route was changed to match the link pattern.\n";
echo "Test completed.\n";