<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\PendidikanModel;
use App\Models\AktivitasModel;
use App\Models\GalleryModel;

class Home extends BaseController
{
    protected $biodataModel;
    protected $pendidikanModel;
    protected $aktivitasModel;
    protected $galleryModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        $this->pendidikanModel = new PendidikanModel();
        $this->aktivitasModel = new AktivitasModel();
        $this->galleryModel = new GalleryModel();
    }

    public function index(): string
    {
        $data = [
            'title' => 'Home - Portfolio Digital',
            // Ambil biodata terbaru agar sinkron dengan tampilan CV/admin
            'biodata' => $this->biodataModel->orderBy('id', 'DESC')->first(),
            'pendidikan' => $this->pendidikanModel->orderBy('tahun_selesai', 'DESC')->findAll(),
            'latestAktivitas' => $this->aktivitasModel
                ->orderBy('created_at', 'DESC')
                ->orderBy('tanggal', 'DESC')
                ->orderBy('jam', 'DESC')
                ->limit(3)
                ->find(),
            'gallery' => $this->galleryModel->orderBy('created_at', 'DESC')->findAll(6),
        ];
        return view('home', $data);
    }

    public function cv(): string
    {
        $data = [
            'title' => 'CV - Portfolio Digital',
            'biodata' => $this->biodataModel->orderBy('id', 'DESC')->first()
        ];
        return view('cv', $data);
    }

    public function biodata_list(): string
    {
        $search = $this->request->getGet('q');
        $jk     = $this->request->getGet('jk');
        $status = $this->request->getGet('status');
        $sort   = $this->request->getGet('sort') ?? 'nama_asc';

        $builder = $this->biodataModel;
        if ($search) {
            $builder = $builder->groupStart()
                ->like('nama', $search)
                ->orLike('email', $search)
                ->orLike('alamat', $search)
                ->groupEnd();
        }
        if ($jk) {
            $builder = $builder->where('jenis_kelamin', $jk);
        }
        if ($status) {
            $builder = $builder->where('status', $status);
        }
        if ($sort === 'nama_desc') {
            $builder = $builder->orderBy('nama', 'DESC');
        } else {
            $builder = $builder->orderBy('nama', 'ASC');
        }

        $biodata = $builder->paginate(10);

        $data = [
            'title'   => 'Biodata - Portfolio Digital',
            'biodata' => $biodata,
            'pager'   => $this->biodataModel->pager,
            'search'  => $search,
            'jk'      => $jk,
            'status'  => $status,
            'sort'    => $sort,
        ];
        return view('biodata_list', $data);
    }

    public function pendidikan(): string
    {
        $search = $this->request->getGet('q');
        $jenjang = $this->request->getGet('jenjang');
        $sort = $this->request->getGet('sort') ?? 'lulus_desc';

        $builder = $this->pendidikanModel;
        if ($search) {
            $builder = $builder->groupStart()
                ->like('institusi', $search)
                ->orLike('jurusan', $search)
                ->groupEnd();
        }
        if ($jenjang) {
            $builder = $builder->where('jenjang', $jenjang);
        }
        switch ($sort) {
            case 'masuk_asc':
                $builder = $builder->orderBy('tahun_mulai', 'ASC');
                break;
            case 'masuk_desc':
                $builder = $builder->orderBy('tahun_mulai', 'DESC');
                break;
            case 'lulus_asc':
                $builder = $builder->orderBy('tahun_selesai', 'ASC');
                break;
            case 'lulus_desc':
            default:
                $builder = $builder->orderBy('tahun_selesai', 'DESC');
                break;
        }

        $pendidikan = $builder->paginate(10);

        $data = [
            'title' => 'Pendidikan - Portfolio Digital',
            'pendidikan' => $pendidikan,
            'pager' => $this->pendidikanModel->pager,
            'search' => $search,
            'jenjang' => $jenjang,
            'sort' => $sort,
        ];
        return view('pendidikan', $data);
    }

    public function aktivitas(): string
    {
        $search = $this->request->getGet('q');
        $jenis  = $this->request->getGet('jenis');
        $tanggalFilter = $this->request->getGet('tanggal');
        $sort   = $this->request->getGet('sort') ?? 'tanggal_desc';

        $builder = $this->aktivitasModel;
        if ($search) {
            $builder = $builder->like('nama_aktivitas', $search);
        }
        if ($tanggalFilter) {
            $builder = $builder->where('tanggal', $tanggalFilter);
        }
        if ($jenis) {
            $builder = $builder->where('jenis', $jenis);
        }
        if ($sort === 'tanggal_asc') {
            $builder = $builder->orderBy('tanggal', 'ASC')->orderBy('jam', 'ASC');
        } else {
            $builder = $builder->orderBy('tanggal', 'DESC')->orderBy('jam', 'DESC');
        }

        $aktivitas = $builder->paginate(10);

        $data = [
            'title' => 'Aktivitas - Portfolio Digital',
            'aktivitas' => $aktivitas,
            'pager' => $this->aktivitasModel->pager,
            'search' => $search,
            'jenis' => $jenis,
            'tanggal' => $tanggalFilter,
            'sort' => $sort,
        ];
        return view('aktivitas', $data);
    }

    public function aktivitas_detail($id): string
    {
        $aktivitas = $this->aktivitasModel->find($id);
        if (!$aktivitas) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Aktivitas tidak ditemukan');
        }
        $data = [
            'title' => 'Detail Aktivitas - ' . ($aktivitas['nama_aktivitas'] ?? ''),
            'item' => $aktivitas,
        ];
        return view('aktivitas_detail', $data);
    }
}
