<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddGenderStatusToBiodata extends Migration
{
    public function up()
    {
        $fields = [];
        if (!$this->db->fieldExists('jenis_kelamin', 'biodata')) {
            $fields['jenis_kelamin'] = [
                'type'       => 'VARCHAR',
                'constraint' => 20,
                'null'       => true,
                'after'      => 'telepon',
            ];
        }
        if (!$this->db->fieldExists('status', 'biodata')) {
            $fields['status'] = [
                'type'       => 'VARCHAR',
                'constraint' => 20,
                'null'       => true,
                'after'      => 'jenis_kelamin',
            ];
        }

        if (!empty($fields)) {
            $this->forge->addColumn('biodata', $fields);
        }
    }

    public function down()
    {
        if ($this->db->fieldExists('jenis_kelamin', 'biodata')) {
            $this->forge->dropColumn('biodata', 'jenis_kelamin');
        }
        if ($this->db->fieldExists('status', 'biodata')) {
            $this->forge->dropColumn('biodata', 'status');
        }
    }
}
