<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddImagePathToPendidikan extends Migration
{
    public function up()
    {
        if (!$this->db->fieldExists('image_path', 'pendidikan')) {
            $this->forge->addColumn('pendidikan', [
                'image_path' => [
                    'type'       => 'VARCHAR',
                    'constraint' => 255,
                    'null'       => true,
                    'after'      => 'deskripsi',
                ],
            ]);
        }
    }

    public function down()
    {
        if ($this->db->fieldExists('image_path', 'pendidikan')) {
            $this->forge->dropColumn('pendidikan', 'image_path');
        }
    }
}
