<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section>
    <h1><?= esc($title ?? 'Form Aktivitas') ?></h1>
    
    <form method="post" enctype="multipart/form-data">
        <div>
            <label for="nama_aktivitas">Judul:</label>
            <input type="text" id="nama_aktivitas" name="nama_aktivitas" value="<?= esc($aktivitas['nama_aktivitas'] ?? $aktivitas['judul'] ?? '') ?>" required>
        </div>

        <div>
            <label for="deskripsi">Deskripsi:</label>
            <textarea id="deskripsi" name="deskripsi" required><?= esc($aktivitas['deskripsi'] ?? '') ?></textarea>
        </div>

        <div>
            <label for="tanggal">Tanggal:</label>
            <input type="date" id="tanggal" name="tanggal" value="<?= esc($aktivitas['tanggal'] ?? '') ?>" required>
        </div>

        <div>
            <label for="jam">Jam (opsional):</label>
            <input type="time" id="jam" name="jam" value="<?= esc($aktivitas['jam'] ?? '') ?>">
        </div>

        <div>
            <label for="jenis">Jenis/Kategori (opsional):</label>
            <input type="text" id="jenis" name="jenis" value="<?= esc($aktivitas['jenis'] ?? '') ?>" placeholder="Workshop, Event, Proyek, dll">
        </div>

        <div>
            <label for="media">Foto/Media:</label>
            <input type="file" id="media" name="media" accept="image/*">
            <p style="margin:0.25rem 0 0; font-size:0.9rem; color:#666;">Format gambar (JPG/PNG). Biarkan kosong jika tidak ada perubahan.</p>
        </div>

        <button type="submit">Simpan</button>
        <a href="<?= base_url('admin/aktivitas') ?>">Batal</a>
    </form>
</section>

<?= $this->endSection() ?>
