<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section>
    <h1>Aktivitas</h1>
    <a href="<?= base_url('admin/aktivitas/create') ?>">Tambah Aktivitas</a>

    <?php if (isset($aktivitas) && count($aktivitas) > 0): ?>
        <table border="1" cellpadding="10">
            <thead>
                <tr>
                    <th>Judul</th>
                    <th>Tanggal</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($aktivitas as $item): ?>
                    <tr>
                        <td><?= esc($item['judul']) ?></td>
                        <td><?= esc($item['tanggal']) ?></td>
                        <td>
                            <a href="<?= base_url('admin/aktivitas/edit/' . $item['id']) ?>">Edit</a>
                            <form method="post" action="<?= base_url('admin/aktivitas/delete/' . $item['id']) ?>" style="display:inline;">
                                <button type="submit" onclick="return confirm('Yakin?');">Hapus</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Tidak ada data aktivitas</p>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
