<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section class="admin-section">
    <div class="admin-section-header">
        <div>
            <p class="eyebrow">Data Personal</p>
            <h1 style="margin: 0;"><?= esc($title ?? 'Form Biodata') ?></h1>
            <p class="muted" style="margin: 0;">Lengkapi biodata untuk ditampilkan di portfolio publik.</p>
        </div>
        <a class="btn-ghost" href="<?= base_url('admin/biodata') ?>">Kembali</a>
    </div>

    <div class="admin-form-card">
        <form method="post" enctype="multipart/form-data" class="admin-form">
            <div class="form-grid">
                <div class="form-group">
                    <label for="nama">Nama</label>
                    <input type="text" id="nama" name="nama" class="form-control" value="<?= esc(old('nama', $biodata['nama'] ?? '')) ?>" required>
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" class="form-control" value="<?= esc(old('email', $biodata['email'] ?? '')) ?>" required>
                </div>

                <div class="form-group">
                    <label for="telepon">Telepon</label>
                    <input type="text" id="telepon" name="telepon" class="form-control" value="<?= esc(old('telepon', $biodata['telepon'] ?? '')) ?>">
                </div>

                <div class="form-group full-span">
                <label for="alamat">Alamat</label>
                <textarea id="alamat" name="alamat" class="form-control" rows="2"><?= esc(old('alamat', $biodata['alamat'] ?? '')) ?></textarea>
            </div>

            <div class="form-group">
                <label for="tempat_lahir">Tempat Lahir</label>
                <input type="text" id="tempat_lahir" name="tempat_lahir" class="form-control" value="<?= esc(old('tempat_lahir', $biodata['tempat_lahir'] ?? '')) ?>">
            </div>

            <div class="form-group">
                <label for="tanggal_lahir">Tanggal Lahir</label>
                <input type="date" id="tanggal_lahir" name="tanggal_lahir" class="form-control" value="<?= esc(old('tanggal_lahir', $biodata['tanggal_lahir'] ?? '')) ?>">
            </div>

            <div class="form-group">
                <label for="agama">Agama</label>
                <input type="text" id="agama" name="agama" class="form-control" value="<?= esc(old('agama', $biodata['agama'] ?? '')) ?>">
            </div>

            <div class="form-group">
                <label for="kewarganegaraan">Kewarganegaraan</label>
                <input type="text" id="kewarganegaraan" name="kewarganegaraan" class="form-control" value="<?= esc(old('kewarganegaraan', $biodata['kewarganegaraan'] ?? '')) ?>">
            </div>

            <div class="form-group">
                <label for="status_pernikahan">Status Pernikahan</label>
                <input type="text" id="status_pernikahan" name="status_pernikahan" class="form-control" value="<?= esc(old('status_pernikahan', $biodata['status_pernikahan'] ?? '')) ?>">
            </div>

            <div class="form-group">
                <label for="golongan_darah">Golongan Darah</label>
                <input type="text" id="golongan_darah" name="golongan_darah" class="form-control" value="<?= esc(old('golongan_darah', $biodata['golongan_darah'] ?? '')) ?>">
            </div>

            <div class="form-group">
                <label for="jenis_kelamin">Jenis Kelamin</label>
                <select id="jenis_kelamin" name="jenis_kelamin" class="form-control">
                    <option value="">-- Pilih --</option>
                    <option value="Laki-laki" <?= old('jenis_kelamin', $biodata['jenis_kelamin'] ?? '') == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= old('jenis_kelamin', $biodata['jenis_kelamin'] ?? '') == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>

            <div class="form-group">
                <label for="status">Status</label>
                <input type="text" id="status" name="status" class="form-control" value="<?= esc(old('status', $biodata['status'] ?? '')) ?>">
            </div>

            <div class="form-group">
                <label for="linkedin">LinkedIn</label>
                <input type="url" id="linkedin" name="linkedin" class="form-control" value="<?= esc(old('linkedin', $biodata['linkedin'] ?? '')) ?>" placeholder="https://linkedin.com/in/...">
            </div>

            <div class="form-group">
                <label for="github">GitHub</label>
                <input type="url" id="github" name="github" class="form-control" value="<?= esc(old('github', $biodata['github'] ?? '')) ?>" placeholder="https://github.com/...">
            </div>

                <div class="form-group full-span">
                    <label for="tentang">Tentang</label>
                    <textarea id="tentang" name="tentang" class="form-control" rows="3"><?= esc(old('tentang', $biodata['tentang'] ?? '')) ?></textarea>
                </div>

                <div class="form-group full-span">
                    <label for="keahlian">Keahlian <span class="muted">(pisahkan dengan koma atau baris baru)</span></label>
                    <textarea id="keahlian" name="keahlian" class="form-control" rows="2"><?= esc(old('keahlian', $biodata['keahlian'] ?? '')) ?></textarea>
                </div>

                <div class="form-group full-span">
                    <label for="pengalaman">Pengalaman</label>
                    <textarea id="pengalaman" name="pengalaman" class="form-control" rows="3"><?= esc(old('pengalaman', $biodata['pengalaman'] ?? '')) ?></textarea>
                </div>

                <div class="form-group full-span">
                    <label for="foto_file">Foto</label>
                    <input type="file" id="foto_file" name="foto_file" accept="image/*" class="form-control">
                </div>
            </div>

            <div class="form-actions">
                <a class="btn-ghost" href="<?= base_url('admin/biodata') ?>">Batal</a>
                <button type="submit" class="btn-primary">Simpan</button>
            </div>
        </form>
    </div>
</section>

<?= $this->endSection() ?>
