<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section>
    <h1><?= esc($title ?? 'Form Biodata') ?></h1>
    
    <form method="post" enctype="multipart/form-data">
        <div>
            <label for="nama">Nama:</label>
            <input type="text" id="nama" name="nama" value="<?= esc($biodata['nama'] ?? '') ?>" required>
        </div>

        <div>
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" value="<?= esc($biodata['email'] ?? '') ?>" required>
        </div>

        <div>
            <label for="telepon">Telepon:</label>
            <input type="text" id="telepon" name="telepon" value="<?= esc($biodata['telepon'] ?? '') ?>">
        </div>

        <div>
            <label for="alamat">Alamat:</label>
            <textarea id="alamat" name="alamat"><?= esc($biodata['alamat'] ?? '') ?></textarea>
        </div>

        <div>
            <label for="jenis_kelamin">Jenis Kelamin:</label>
            <select id="jenis_kelamin" name="jenis_kelamin">
                <option value="">-- Pilih --</option>
                <option value="Laki-laki" <?= ($biodata['jenis_kelamin'] ?? '') == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                <option value="Perempuan" <?= ($biodata['jenis_kelamin'] ?? '') == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
            </select>
        </div>

        <div>
            <label for="status">Status:</label>
            <input type="text" id="status" name="status" value="<?= esc($biodata['status'] ?? '') ?>">
        </div>

        <div>
            <label for="tentang">Tentang:</label>
            <textarea id="tentang" name="tentang"><?= esc($biodata['tentang'] ?? '') ?></textarea>
        </div>

        <div>
            <label for="keahlian">Keahlian:</label>
            <textarea id="keahlian" name="keahlian"><?= esc($biodata['keahlian'] ?? '') ?></textarea>
        </div>

        <div>
            <label for="pengalaman">Pengalaman:</label>
            <textarea id="pengalaman" name="pengalaman"><?= esc($biodata['pengalaman'] ?? '') ?></textarea>
        </div>

        <div>
            <label for="foto_file">Foto:</label>
            <input type="file" id="foto_file" name="foto_file" accept="image/*">
        </div>

        <button type="submit">Simpan</button>
        <a href="<?= base_url('admin/biodata') ?>">Batal</a>
    </form>
</section>

<?= $this->endSection() ?>
