<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section class="admin-section">
    <div class="admin-section-header">
        <div>
            <p class="eyebrow">Data Personal</p>
            <h1 style="margin: 0;">Biodata</h1>
            <p class="muted" style="margin: 0;">Kelola informasi biodata untuk halaman portfolio.</p>
        </div>
        <div class="admin-header-actions">
            <a class="btn-primary" href="<?= base_url('admin/biodata/create') ?>">Tambah Biodata</a>
        </div>
    </div>

    <?php if (isset($biodata) && count($biodata) > 0): ?>
        <?php
            $item = $biodata[0];
            $photoPath = $item['foto'] ?? '';
            $photoUrl = $photoPath ? base_url(ltrim($photoPath, '/')) : 'https://via.placeholder.com/200';
        ?>
        <div class="cv-card" style="max-width: 900px; margin-top: 1rem;">
            <div style="display:flex; gap:1.5rem; align-items:center; margin-bottom:1.5rem; border-bottom:1px solid #ddd; padding-bottom:1.25rem;">
                <div style="width: 150px; height: 150px; background: #eee; border-radius: 50%; overflow: hidden; flex-shrink: 0;">
                    <img src="<?= esc($photoUrl) ?>" alt="Foto" style="width: 100%; height: 100%; object-fit: cover;">
                </div>
                <div>
                    <h1 style="margin:0; font-size:2.4rem; color:#111;"><?= esc($item['nama'] ?? '-') ?></h1>
                    <p style="margin:0.4rem 0 0; font-size:1.2rem; color:#444;"><?= esc($item['status'] ?? 'Professional') ?></p>
                    <div style="margin-top:0.8rem; display:flex; gap:0.5rem; flex-wrap:wrap;">
                        <a class="chip-link" href="<?= base_url('admin/biodata/edit/' . $item['id']) ?>">Edit</a>
                        <a class="chip-link" href="<?= base_url('admin/biodata/detail/' . $item['id']) ?>">Lihat</a>
                        <form method="post" action="<?= base_url('admin/biodata/delete/' . $item['id']) ?>" onsubmit="return confirm('Yakin hapus biodata ini?');" style="display:inline;">
                            <?= csrf_field() ?>
                            <button class="chip-link danger" type="submit">Hapus</button>
                        </form>
                    </div>
                </div>
            </div>

            <div style="display: grid; gap: 1.25rem;">
                <section>
                    <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px; color:#111;">Profil Singkat</h2>
                    <p style="line-height:1.6; margin:0; color:#444;"><?= nl2br(esc($item['tentang'] ?? 'Belum ada profil.')) ?></p>
                </section>

                <section>
                    <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px; color:#111;">Identitas</h2>
                    <div style="display:grid; gap:0.35rem; color:#444; font-size:0.95rem;">
                        <div><strong>Tempat / Tanggal Lahir:</strong> <?= esc($item['tempat_lahir'] ?? '-') ?>, <?= esc($item['tanggal_lahir'] ?? '-') ?></div>
                        <div><strong>Alamat:</strong> <?= esc($item['alamat'] ?? '-') ?></div>
                        <div><strong>Agama:</strong> <?= esc($item['agama'] ?? '-') ?></div>
                        <div><strong>Kewarganegaraan:</strong> <?= esc($item['kewarganegaraan'] ?? '-') ?></div>
                        <div><strong>Status Pernikahan:</strong> <?= esc($item['status_pernikahan'] ?? '-') ?></div>
                        <div><strong>Golongan Darah:</strong> <?= esc($item['golongan_darah'] ?? '-') ?></div>
                    </div>
                </section>

                <section>
                    <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px; color:#111;">Kontak</h2>
                    <div style="display:grid; gap:0.35rem; color:#444; font-size:0.95rem;">
                        <div><strong>Email:</strong> <?= esc($item['email'] ?? '-') ?></div>
                        <div><strong>Telepon:</strong> <?= esc($item['telepon'] ?? '-') ?></div>
                        <?php if (!empty($item['linkedin']) || !empty($item['github'])): ?>
                            <div style="display:flex; gap:0.8rem; flex-wrap:wrap;">
                                <?php if (!empty($item['linkedin'])): ?>
                                    <span><a href="<?= esc($item['linkedin']) ?>" target="_blank" rel="noopener">LinkedIn</a></span>
                                <?php endif; ?>
                                <?php if (!empty($item['github'])): ?>
                                    <span><a href="<?= esc($item['github']) ?>" target="_blank" rel="noopener">GitHub</a></span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </section>

                <?php if (!empty($item['keahlian'])): ?>
                    <?php $skills = array_filter(array_map('trim', preg_split('/[,\\n]+/', $item['keahlian']))); ?>
                    <section>
                        <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px; color:#111;">Keahlian</h2>
                        <?php if (!empty($skills)): ?>
                            <ul style="margin:0; padding-left:1.2rem; color:#444; line-height:1.6;">
                                <?php foreach ($skills as $skill): ?>
                                    <li><?= esc($skill) ?></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php else: ?>
                            <p style="margin:0; color:#444;"><?= nl2br(esc($item['keahlian'])) ?></p>
                        <?php endif; ?>
                    </section>
                <?php endif; ?>

                <?php if (!empty($item['pengalaman'])): ?>
                    <section>
                        <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px; color:#111;">Pengalaman</h2>
                        <p style="margin:0; color:#444; line-height:1.6;"><?= nl2br(esc($item['pengalaman'])) ?></p>
                    </section>
                <?php endif; ?>
            </div>
        </div>
    <?php else: ?>
        <div class="admin-empty">
            <p class="muted">Belum ada biodata.</p>
            <a class="btn-primary" href="<?= base_url('admin/biodata/create') ?>">Tambah Biodata</a>
        </div>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
