<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section>
    <h1>Biodata</h1>
    <a href="<?= base_url('admin/biodata/create') ?>">Tambah Biodata</a>

    <?php if (isset($biodata) && count($biodata) > 0): ?>
        <table border="1" cellpadding="10">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Email</th>
                    <th>Telepon</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($biodata as $item): ?>
                    <tr>
                        <td><?= esc($item['nama']) ?></td>
                        <td><?= esc($item['email']) ?></td>
                        <td><?= esc($item['telepon']) ?></td>
                        <td>
                            <a href="<?= base_url('admin/biodata/detail/' . $item['id']) ?>">Lihat</a>
                            <a href="<?= base_url('admin/biodata/edit/' . $item['id']) ?>">Edit</a>
                            <form method="post" action="<?= base_url('admin/biodata/delete/' . $item['id']) ?>" style="display:inline;">
                                <button type="submit" onclick="return confirm('Yakin?');">Hapus</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Tidak ada data biodata</p>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
