<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section class="admin-section">
    <div class="admin-section-header">
        <div>
            <p class="eyebrow">Gallery</p>
            <h1 style="margin:0;">Kelola Foto</h1>
            <p class="muted" style="margin:0;">Unggah foto untuk ditampilkan di halaman publik.</p>
        </div>
    </div>

    <div class="admin-form-card">
        <form method="post" enctype="multipart/form-data" class="admin-form">
            <?= csrf_field() ?>
            <div class="form-grid">
                <div class="form-group">
                    <label for="title">Judul</label>
                    <input type="text" id="title" name="title" class="form-control" required>
                </div>
                <div class="form-group full-span">
                    <label for="description">Deskripsi (opsional)</label>
                    <textarea id="description" name="description" class="form-control" rows="2"></textarea>
                </div>
                <div class="form-group full-span">
                    <label for="image">Foto</label>
                    <input type="file" id="image" name="image" class="form-control" accept="image/*" required>
                </div>
            </div>
            <div class="form-actions">
                <button type="submit" class="btn-primary">Tambah Foto</button>
            </div>
        </form>
    </div>

    <div class="gallery-grid">
        <?php if (!empty($items)): ?>
            <?php foreach ($items as $item): ?>
                <div class="gallery-card">
                    <div class="gallery-thumb" style="background-image: url('<?= base_url($item['image_path']) ?>'); background-size: cover; background-position: center;"></div>
                    <div class="gallery-meta">
                        <h4><?= esc($item['title']) ?></h4>
                        <?php if (!empty($item['description'])): ?>
                            <p class="muted"><?= esc($item['description']) ?></p>
                        <?php endif; ?>
                        <div class="action-links">
                            <form method="post" action="<?= base_url('admin/gallery/delete/' . $item['id']) ?>" onsubmit="return confirm('Hapus foto ini?');">
                                <?= csrf_field() ?>
                                <button class="chip-link danger" type="submit">Hapus</button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="admin-empty">
                <p class="muted">Belum ada foto.</p>
            </div>
        <?php endif; ?>
    </div>
</section>

<?= $this->endSection() ?>
