<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<div class="page-header">
    <h1 class="page-title">Aktivitas</h1>
    <p style="color: var(--text-dim);">Kegiatan, projek, dan pencapaian terbaru.</p>
</div>

<div class="container" style="max-width: 1200px; margin: 0 auto; padding-bottom: 4rem;">
    
    <!-- Filter -->
    <div class="filter-container">
        <form class="filter-form" method="get" action="<?= base_url('aktivitas') ?>">
            <div class="form-group">
                <label>Cari Aktivitas</label>
                <input type="text" name="q" class="form-control" value="<?= esc($search ?? '') ?>" placeholder="Judul aktivitas...">
            </div>
            <div class="form-group">
                <label>Tanggal</label>
                <input type="date" name="tanggal" class="form-control" value="<?= esc($tanggal ?? '') ?>">
            </div>
            <div class="form-group" style="flex: 0 0 auto;">
                <button type="submit" class="btn-primary" style="border:none; cursor:pointer;">Cari</button>
            </div>
        </form>
    </div>

    <!-- Grid Layout -->
    <div class="activities-grid" style="padding: 0 2rem;">
        <?php if (!empty($aktivitas) && count($aktivitas) > 0): ?>
            <?php foreach ($aktivitas as $item): ?>
                <?php $mediaUrl = !empty($item['file_path']) ? base_url(ltrim($item['file_path'], '/')) : 'https://via.placeholder.com/400x300?text=Activity'; ?>
                <div class="activity-card" style="display: flex; flex-direction: column; height: 100%;">
                    <div class="activity-img">
                         <img src="<?= esc($mediaUrl) ?>" alt="<?= esc($item['nama_aktivitas'] ?? $item['judul'] ?? 'Aktivitas') ?>" style="width:100%; height:100%; object-fit:cover;">
                    </div>
                    <div class="activity-info" style="display: flex; flex-direction: column; flex: 1;">
                        <span class="activity-date">
                            <?= date('d M Y', strtotime($item['tanggal'] ?? $item['date'] ?? 'now')) ?>
                        </span>
                        <h3 style="margin-top: 0.5rem; color: var(--text-light);">
                            <?= esc($item['nama_aktivitas'] ?? $item['judul'] ?? 'Judul Aktivitas') ?>
                        </h3>
                        <p style="color: var(--text-dim); flex-grow: 1;">
                            <?= substr(strip_tags($item['deskripsi'] ?? $item['description'] ?? ''), 0, 100) ?>...
                        </p>
                        <div style="margin-top: auto;">
                            <a href="<?= base_url('aktivitas/' . $item['id']) ?>" class="btn-primary" style="padding: 0.5rem 1.5rem; font-size: 0.9rem; display: inline-block;">
                                Lihat Detail
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div style="grid-column: 1 / -1; text-align: center; color: var(--text-dim); padding: 4rem;">
                <p>Tidak ada aktivitas ditemukan.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if (!empty($pager)): ?>
        <div style="margin-top: 4rem;">
            <?= $pager->links() ?>
        </div>
    <?php endif; ?>

</div>

<?= $this->endSection() ?>
