<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<div class="page-header">
    <h1 class="page-title">Detail Aktivitas</h1>
    <p style="color: var(--text-dim);">
        <a href="<?= base_url('aktivitas') ?>" style="color: var(--text-dim); text-decoration: none;">&larr; Kembali ke Daftar</a>
    </p>
</div>

<div class="container" style="max-width: 900px; margin: 0 auto; padding: 0 2rem 4rem;">
    <article style="background: var(--card-bg); border: 1px solid var(--glass-border); border-radius: 16px; padding: 2rem; overflow: hidden;">
        
        <header style="margin-bottom: 2rem; text-align: center;">
            <h1 style="font-size: 2.5rem; margin-bottom: 0.5rem; color: var(--text-light);">
                <?= esc($item['nama_aktivitas'] ?? $item['judul'] ?? 'Aktivitas') ?>
            </h1>
            <span style="color: var(--primary-color); font-weight: 600;">
                <?= date('d F Y', strtotime($item['tanggal'] ?? $item['date'] ?? 'now')) ?>
            </span>
        </header>

        <?php
            $detailMedia = !empty($item['file_path'])
                ? base_url(ltrim($item['file_path'], '/'))
                : 'https://via.placeholder.com/900x400?text=Activity+Banner';
        ?>
        <div style="width: 100%; height: 400px; background: #333; border-radius: 12px; overflow: hidden; margin-bottom: 2rem;">
            <img src="<?= esc($detailMedia) ?>" alt="<?= esc($item['nama_aktivitas'] ?? '') ?>" style="width: 100%; height: 100%; object-fit: cover;">
        </div>

        <div class="content" style="font-size: 1.1rem; color: var(--text-dim); line-height: 1.8;">
            <?= nl2br(esc($item['deskripsi'] ?? $item['description'] ?? 'Tidak ada deskripsi.')) ?>
        </div>

        <?php if (!empty($item['dokumentasi'])): ?>
            <div style="margin-top: 2rem;">
                 <h3 style="color: var(--text-light);">Dokumentasi</h3>
                 <!-- Logic to show documentation images if they exist -->
                 <p><?= esc($item['dokumentasi']) ?></p>
            </div>
        <?php endif; ?>

    </article>
</div>

<?= $this->endSection() ?>
