<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<?php
    $biodata   = $biodata ?? null;
    $photoPath = $biodata['foto'] ?? '';
    $photoUrl  = $photoPath ? base_url(ltrim($photoPath, '/')) : 'https://via.placeholder.com/200';
?>

<section>
    <h1>Home - Portfolio</h1>
    <?php if ($biodata): ?>
        <h2><?= esc($biodata['nama']) ?></h2>
        <?php if ($photoUrl): ?>
            <img src="<?= $photoUrl ?>" alt="<?= esc($biodata['nama']) ?>" width="200">
        <?php endif; ?>
        <p><?= nl2br(esc($biodata['tentang'] ?? '')) ?></p>
        <p>Email: <?= esc($biodata['email'] ?? '') ?></p>
        <p>Telepon: <?= esc($biodata['telepon'] ?? '') ?></p>
        <p>Alamat: <?= esc($biodata['alamat'] ?? '') ?></p>
    <?php else: ?>
        <p>Biodata tidak tersedia</p>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
