<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? esc($title) : 'Admin Dashboard' ?></title>
    <!-- Favicon -->
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="<?= base_url('css/style.css?v=' . time()) ?>">
</head>
<body class="admin-body" style="--bg-image: url('<?= base_url('uploads/15022e6e99f21eaf653b694f7762f160.jpg') ?>');">
    <!-- Navigation -->
    <?php $showNav = empty($hideNav); ?>
    <?php if ($showNav): ?>
        <nav class="main-nav">
            <div>
                <div class="nav-brand">
                    <a href="<?= base_url('admin') ?>">Dashboard</a>
                </div>
                <ul>
                    <li><a href="<?= base_url('admin/biodata') ?>" class="<?= url_is('admin/biodata*') ? 'active' : '' ?>">Biodata</a></li>
                    <li><a href="<?= base_url('admin/pendidikan') ?>" class="<?= url_is('admin/pendidikan*') ? 'active' : '' ?>">Pendidikan</a></li>
                    <li><a href="<?= base_url('admin/aktivitas') ?>" class="<?= url_is('admin/aktivitas*') ? 'active' : '' ?>">Aktivitas</a></li>
                </ul>
                <button class="mobile-menu-btn">Menu</button>
            </div>
        </nav>
    <?php endif; ?>

    <!-- Main Content -->
    <main>
        <div class="container">
            <?php if (session()->getFlashdata('success')): ?>
                <div class="alert alert-success">
                    <?= esc(session()->getFlashdata('success')) ?>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
                <div class="alert alert-danger">
                    <?= esc(session()->getFlashdata('error')) ?>
                </div>
            <?php endif; ?>

            <?= $this->renderSection('content') ?>
        </div>
    </main>

    <!-- Mobile Menu Handler -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuBtn = document.querySelector('.main-nav .mobile-menu-btn');
            const navLinks = document.querySelector('.main-nav ul');
            if (mobileMenuBtn && navLinks) {
                mobileMenuBtn.addEventListener('click', function() {
                    navLinks.classList.toggle('open');
                });
            }
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
