<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? esc($title) : 'Portfolio Digital' ?></title>
    <!-- Favicon -->
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
</head>
<body>
    <!-- Navigation -->
    <nav>
        <div>
            <div class="nav-brand"></div>
            <ul>
                <li><a href="<?= base_url() ?>" class="<?= url_is('/') ? 'active' : '' ?>">Home</a></li>
                <li><a href="<?= base_url('cv') ?>" class="<?= url_is('cv') ? 'active' : '' ?>">Biodata</a></li>
                <li><a href="<?= base_url('pendidikan') ?>" class="<?= url_is('pendidikan') ? 'active' : '' ?>">Pendidikan</a></li>
                <li><a href="<?= base_url('aktivitas') ?>" class="<?= url_is('aktivitas') ? 'active' : '' ?>">Aktivitas</a></li>
            </ul>
            <button class="mobile-menu-btn">Menu</button>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer>
        <div>
            <div>
                <div>
                    <a href="https://wa.me/6285717421905" target="_blank" rel="noopener">WhatsApp</a>
                </div>
                <div>
                    <a href="https://www.instagram.com/titik_pake?igsh=MWd4OXg2MjdpNGliaA==" target="_blank" rel="noopener">Instagram</a>
                </div>
                <div>
                    <a href="https://x.com/DANIELFERN80300?t=s-X0tLfaMc2D4v-tRtxEjw&s=08" target="_blank" rel="noopener">Twitter</a>
                </div>
                <div>
                    <a href="https://www.linkedin.com/in/daniel-fernando-914a102ba?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=android_app" target="_blank" rel="noopener">LinkedIn</a>
                </div>
                <div>
                    <a href="https://github.com/DANIELFERN80300" target="_blank" rel="noopener">GitHub</a>
                </div>
                <div>
                    <a href="https://youtube.com/@danielfernando-t9n?si=ityBML_iraOYdFfM" target="_blank" rel="noopener">YouTube</a>
                </div>
            </div>
            <p>&copy; <?= date('Y') ?> Furqonisme | Portfolio Digital | 2025</p>
        </div>
    </footer>

    <!-- Mobile Menu Handler -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
            const navLinks = document.querySelector('nav ul');
            if (mobileMenuBtn && navLinks) {
                mobileMenuBtn.addEventListener('click', function() {
                    navLinks.classList.toggle('open');
                });
            }
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
