<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AdminUserModel;

class AuthController extends BaseController
{
    protected $adminModel;

    public function __construct()
    {
        $this->adminModel = new AdminUserModel();
    }

    public function login()
    {
        // If already logged in, redirect to dashboard
        if (session()->get('admin_logged_in')) {
            return redirect()->to('/admin/dashboard');
        }

        return view('admin/login', [
            'title' => 'Login Admin'
        ]);
    }

    public function attemptLogin()
    {
        // Validate input
        $rules = [
            'username' => 'required',
            'password' => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('error', 'Username dan password wajib diisi.');
        }

        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        // Find user
        $user = $this->adminModel->findByLogin($username);

        if (!$user) {
            return redirect()->back()->withInput()->with('error', 'Username atau password salah.');
        }

        // Verify password
        if (!$this->adminModel->verifyPassword($password, $user['password_hash'])) {
            return redirect()->back()->withInput()->with('error', 'Username atau password salah.');
        }

        // Set session
        session()->set([
            'admin_id'        => $user['id'],
            'admin_username'  => $user['username'],
            'admin_email'     => $user['email'],
            'admin_logged_in' => true,
        ]);

        // Redirect to intended URL or dashboard
        $redirectUrl = session()->get('redirect_url') ?? '/admin/dashboard';
        session()->remove('redirect_url');

        return redirect()->to($redirectUrl)->with('success', 'Selamat datang, ' . $user['username'] . '!');
    }

    public function logout()
    {
        // Destroy session
        session()->destroy();

        return redirect()->to('/admin/login')->with('success', 'Anda telah logout.');
    }
}
