<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ActivityModel;
use App\Models\EducationModel;
use App\Models\ContactMessageModel;
use App\Models\BiodataModel;

class DashboardController extends BaseController
{
    public function index()
    {
        helper('media');
        
        $activityModel = new ActivityModel();
        $educationModel = new EducationModel();
        $messageModel = new ContactMessageModel();
        $biodataModel = new BiodataModel();

        $biodata = $biodataModel->getBiodata();

        $data = [
            'title' => 'Dashboard Admin',
            'stats' => [
                'total_activities'  => $activityModel->countAllResults(),
                'total_educations'  => $educationModel->countAllResults(),
                'unread_messages'   => $messageModel->getUnreadCount(),
                'published'         => $activityModel->where('status', 'publish')->countAllResults(),
            ],
            'recent_activities' => $activityModel->orderBy('created_at', 'DESC')->limit(5)->findAll(),
            'recent_messages'   => $messageModel->getRecent(5),
            'biodata'           => $biodata,
        ];

        return view('admin/dashboard', $data);
    }
}
