<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ContactMessageModel;

class MessagesController extends BaseController
{
    protected $messageModel;

    public function __construct()
    {
        $this->messageModel = new ContactMessageModel();
    }

    public function index()
    {
        $messages = $this->messageModel->orderBy('created_at', 'DESC')->findAll();

        $data = [
            'title'    => 'Pesan Kontak',
            'messages' => $messages,
        ];

        return view('admin/messages/index', $data);
    }

    public function read($id)
    {
        $message = $this->messageModel->find($id);

        if (!$message) {
            return redirect()->to('/admin/messages')->with('error', 'Pesan tidak ditemukan.');
        }

        // Mark as read
        $this->messageModel->markAsRead($id);

        $data = [
            'title'   => 'Detail Pesan',
            'message' => $message,
        ];

        return view('admin/messages/read', $data);
    }

    public function delete($id)
    {
        $message = $this->messageModel->find($id);

        if (!$message) {
            return redirect()->to('/admin/messages')->with('error', 'Pesan tidak ditemukan.');
        }

        if ($this->messageModel->delete($id)) {
            return redirect()->to('/admin/messages')->with('success', 'Pesan berhasil dihapus!');
        }

        return redirect()->to('/admin/messages')->with('error', 'Gagal menghapus pesan.');
    }
}
