<?php

namespace App\Controllers;

use App\Models\EducationModel;
use App\Models\SettingsModel;

class EducationController extends BaseController
{
    protected $educationModel;
    protected $settingsModel;

    public function __construct()
    {
        $this->educationModel = new EducationModel();
        $this->settingsModel = new SettingsModel();
        helper('media');
    }

    public function index()
    {
        $settings = $this->settingsModel->getAllSettings();
        $educations = $this->educationModel->getAllOrdered();

        $data = [
            'title'       => 'Pendidikan - ' . ($settings['site_title'] ?? 'Portfolio'),
            'description' => 'Riwayat pendidikan dan prestasi akademik',
            'educations'  => $educations,
            'settings'    => $settings,
        ];

        return view('public/education', $data);
    }
}
