<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ActivitySeeder extends Seeder
{
    public function run()
    {
        $activities = [
            [
                'title'         => 'Membangun Website E-Commerce Modern',
                'slug'          => 'membangun-website-e-commerce-modern',
                'activity_date' => '2024-12-15',
                'category'      => 'Project',
                'tags_json'     => json_encode(['PHP', 'Laravel', 'Vue.js', 'MySQL']),
                'content'       => '<p>Mengembangkan platform e-commerce full-stack dengan fitur keranjang belanja, pembayaran terintegrasi, dan dashboard admin yang komprehensif.</p><h3>Fitur Utama</h3><ul><li>Sistem autentikasi dan otorisasi</li><li>Manajemen produk dan kategori</li><li>Keranjang belanja real-time</li><li>Integrasi payment gateway</li><li>Dashboard admin responsif</li></ul><p>Project ini menggunakan Laravel sebagai backend dan Vue.js untuk frontend interaktif.</p>',
                'thumbnail'     => null,
                'status'        => 'publish',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Bootcamp Full-Stack Web Development',
                'slug'          => 'bootcamp-full-stack-web-development',
                'activity_date' => '2024-11-01',
                'category'      => 'Training',
                'tags_json'     => json_encode(['JavaScript', 'Node.js', 'React', 'MongoDB']),
                'content'       => '<p>Mengikuti program bootcamp intensif selama 3 bulan yang mencakup pengembangan web full-stack menggunakan JavaScript ecosystem.</p><h3>Materi yang Dipelajari</h3><ul><li>JavaScript ES6+ Advanced</li><li>React.js dan State Management</li><li>Node.js dan Express.js</li><li>MongoDB dan Mongoose</li><li>RESTful API Design</li><li>Deployment dan DevOps dasar</li></ul>',
                'thumbnail'     => null,
                'status'        => 'publish',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Sertifikasi Google Cloud Platform',
                'slug'          => 'sertifikasi-google-cloud-platform',
                'activity_date' => '2024-10-20',
                'category'      => 'Certification',
                'tags_json'     => json_encode(['Cloud', 'GCP', 'DevOps']),
                'content'       => '<p>Berhasil mendapatkan sertifikasi Google Cloud Associate Cloud Engineer yang memvalidasi kemampuan dalam mengelola infrastruktur cloud.</p><h3>Kompetensi yang Divalidasi</h3><ul><li>Setting up cloud solution environments</li><li>Planning and configuring cloud resources</li><li>Deploying and implementing solutions</li><li>Ensuring successful operation of solutions</li><li>Configuring access and security</li></ul>',
                'thumbnail'     => null,
                'status'        => 'publish',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Speaker di Tech Conference 2024',
                'slug'          => 'speaker-di-tech-conference-2024',
                'activity_date' => '2024-09-15',
                'category'      => 'Event',
                'tags_json'     => json_encode(['Speaking', 'Conference', 'Web Development']),
                'content'       => '<p>Menjadi pembicara di Tech Conference 2024 dengan topik "Modern Web Development Practices" di hadapan lebih dari 500 peserta.</p><h3>Topik yang Dibahas</h3><ul><li>Trend teknologi web terkini</li><li>Best practices dalam pengembangan web</li><li>Performance optimization techniques</li><li>Security considerations</li></ul>',
                'thumbnail'     => null,
                'status'        => 'publish',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Kontribusi Open Source Library',
                'slug'          => 'kontribusi-open-source-library',
                'activity_date' => '2024-08-10',
                'category'      => 'Open Source',
                'tags_json'     => json_encode(['Open Source', 'PHP', 'GitHub']),
                'content'       => '<p>Berkontribusi pada berbagai project open source, termasuk membuat library PHP untuk integrasi payment gateway lokal Indonesia.</p><h3>Kontribusi Utama</h3><ul><li>Bug fixes dan feature improvements</li><li>Documentation improvements</li><li>Code review dan mentoring</li><li>Membuat library baru untuk komunitas</li></ul>',
                'thumbnail'     => null,
                'status'        => 'publish',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'title'         => 'Redesign UI/UX Mobile Banking App',
                'slug'          => 'redesign-ui-ux-mobile-banking-app',
                'activity_date' => '2024-07-01',
                'category'      => 'Project',
                'tags_json'     => json_encode(['UI/UX', 'Figma', 'Mobile App']),
                'content'       => '<p>Melakukan redesign lengkap untuk aplikasi mobile banking dengan fokus pada user experience dan accessibility.</p><h3>Proses Design</h3><ul><li>User research dan persona mapping</li><li>Wireframing dan prototyping</li><li>Usability testing</li><li>Design system creation</li><li>Handoff to development team</li></ul><p>Hasil redesign meningkatkan user satisfaction score sebesar 40%.</p>',
                'thumbnail'     => null,
                'status'        => 'publish',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
        ];

        foreach ($activities as $activity) {
            $this->db->table('activities')->insert($activity);
        }
    }
}
