<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class SettingsSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            [
                'setting_key' => 'site_title',
                'value'       => 'Hanif - Portfolio',
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'setting_key' => 'site_description',
                'value'       => 'Portfolio website Hanif - Full-Stack Developer & UI/UX Designer',
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'setting_key' => 'meta_description',
                'value'       => 'Website portfolio profesional yang menampilkan project, skill, dan pengalaman dalam pengembangan web dan desain UI/UX.',
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'setting_key' => 'og_image',
                'value'       => null,
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'setting_key' => 'footer_text',
                'value'       => '© 2024 Hanif. All rights reserved.',
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
        ];

        foreach ($settings as $setting) {
            $this->db->table('settings')->insert($setting);
        }
    }
}
