<?php

namespace App\Models;

use CodeIgniter\Model;

class BiodataModel extends Model
{
    protected $table            = 'biodata';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'name', 'headline', 'summary', 'photo', 'email', 
        'phone', 'location', 'socials_json', 'skills_json', 
        'tools_json', 'cv_file'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = '';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'name'  => 'required|max_length[255]',
        'email' => 'permit_empty|valid_email',
    ];

    protected $validationMessages = [
        'name' => [
            'required' => 'Nama wajib diisi.',
        ],
    ];

    /**
     * Get biodata (always single record)
     */
    public function getBiodata(): ?array
    {
        $data = $this->first();
        if ($data) {
            $data['socials'] = json_decode($data['socials_json'] ?? '{}', true) ?: [];
            $data['skills'] = json_decode($data['skills_json'] ?? '[]', true) ?: [];
            $data['tools'] = json_decode($data['tools_json'] ?? '[]', true) ?: [];
        }
        return $data;
    }

    /**
     * Save biodata (create or update)
     */
    public function saveBiodata(array $data): bool
    {
        // Encode JSON fields
        if (isset($data['socials']) && is_array($data['socials'])) {
            $data['socials_json'] = json_encode($data['socials']);
            unset($data['socials']);
        }
        if (isset($data['skills']) && is_array($data['skills'])) {
            $data['skills_json'] = json_encode($data['skills']);
            unset($data['skills']);
        }
        if (isset($data['tools']) && is_array($data['tools'])) {
            $data['tools_json'] = json_encode($data['tools']);
            unset($data['tools']);
        }

        $existing = $this->first();
        if ($existing) {
            return $this->update($existing['id'], $data);
        }
        return $this->insert($data) !== false;
    }
}
