<?php

namespace App\Models;

use CodeIgniter\Model;

class ContactMessageModel extends Model
{
    protected $table            = 'contact_messages';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['name', 'email', 'message', 'is_read'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = '';

    // Validation
    protected $validationRules = [
        'name'    => 'required|max_length[255]',
        'email'   => 'required|valid_email|max_length[255]',
        'message' => 'required|max_length[5000]',
    ];

    protected $validationMessages = [
        'name' => [
            'required' => 'Nama wajib diisi.',
        ],
        'email' => [
            'required'    => 'Email wajib diisi.',
            'valid_email' => 'Format email tidak valid.',
        ],
        'message' => [
            'required' => 'Pesan wajib diisi.',
        ],
    ];

    /**
     * Get unread messages count
     */
    public function getUnreadCount(): int
    {
        return $this->where('is_read', 0)->countAllResults();
    }

    /**
     * Mark message as read
     */
    public function markAsRead(int $id): bool
    {
        return $this->update($id, ['is_read' => 1]);
    }

    /**
     * Get recent messages
     */
    public function getRecent(int $limit = 10): array
    {
        return $this->orderBy('created_at', 'DESC')
                    ->limit($limit)
                    ->findAll();
    }
}
