<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header -->
<div class="mb-6">
    <h2 class="text-2xl font-bold text-white">Edit Aktivitas</h2>
    <p class="text-sm text-slate-300 mt-1">Ubah data aktivitas, project, atau kegiatan</p>
</div>

<div class="card p-6 max-w-4xl">
    <form action="<?= base_url('admin/activities/update/' . $activity['id']) ?>" method="post" enctype="multipart/form-data" class="space-y-6">
        <?= csrf_field() ?>
        
        <div class="grid md:grid-cols-3 gap-4">
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-slate-200 mb-2">Judul Aktivitas *</label>
                <input type="text" name="title" value="<?= esc($activity['title']) ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" required>
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-200 mb-2">Tanggal</label>
                <input type="date" name="activity_date" value="<?= esc($activity['activity_date']) ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all">
            </div>
        </div>
        
        <div class="grid md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-slate-200 mb-2">Kategori</label>
                <select name="category" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all">
                    <option value="">Pilih Kategori</option>
                    <option value="Project" <?= ($activity['category'] ?? '') === 'Project' ? 'selected' : '' ?>>Project</option>
                    <option value="Training" <?= ($activity['category'] ?? '') === 'Training' ? 'selected' : '' ?>>Training</option>
                    <option value="Sertifikasi" <?= ($activity['category'] ?? '') === 'Sertifikasi' ? 'selected' : '' ?>>Sertifikasi</option>
                    <option value="Kompetisi" <?= ($activity['category'] ?? '') === 'Kompetisi' ? 'selected' : '' ?>>Kompetisi</option>
                    <option value="Organisasi" <?= ($activity['category'] ?? '') === 'Organisasi' ? 'selected' : '' ?>>Organisasi</option>
                    <option value="Lainnya" <?= ($activity['category'] ?? '') === 'Lainnya' ? 'selected' : '' ?>>Lainnya</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-200 mb-2">Status</label>
                <select name="status" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all">
                    <option value="draft" <?= $activity['status'] === 'draft' ? 'selected' : '' ?>>Draft</option>
                    <option value="publish" <?= $activity['status'] === 'publish' ? 'selected' : '' ?>>Publish</option>
                </select>
            </div>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Tags</label>
            <input type="text" name="tags" value="<?= esc(implode(', ', $activity['tags'] ?? [])) ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="PHP, Laravel, Vue.js (pisahkan dengan koma)">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Konten</label>
            <textarea name="content" rows="12" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none resize-none font-mono text-sm transition-all"><?= esc($activity['content']) ?></textarea>
            <p class="text-xs text-slate-400 mt-1">Mendukung HTML (h2, h3, p, ul, li, blockquote, pre, code)</p>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Thumbnail</label>
            <?php if (!empty($activity['thumbnail'])): ?>
            <div class="mb-3">
                <img src="<?= media_url($activity['thumbnail']) ?>" alt="" class="w-32 h-20 object-cover rounded-lg ring-1 ring-slate-600">
            </div>
            <?php endif; ?>
            <input type="file" name="thumbnail" accept="image/*" class="text-sm text-slate-300 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary/20 file:text-primary hover:file:bg-primary/30 file:transition-colors file:cursor-pointer cursor-pointer">
        </div>
        
        <div class="flex justify-end gap-3 pt-6 border-t border-slate-700/50">
            <a href="<?= base_url('admin/activities') ?>" class="px-6 py-3 rounded-xl bg-slate-700 text-slate-200 hover:bg-slate-600 transition-all font-medium">Batal</a>
            <button type="submit" class="px-6 py-3 rounded-xl bg-gradient-to-r from-primary to-purple-600 text-white font-medium hover:shadow-lg hover:shadow-primary/30 transition-all flex items-center gap-2">
                <i data-lucide="save" class="w-5 h-5"></i>
                Simpan Perubahan
            </button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>
