<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header -->
<div class="mb-6">
    <h2 class="text-2xl font-bold text-white">Tambah Pendidikan</h2>
    <p class="text-sm text-slate-300 mt-1">Tambah riwayat pendidikan baru</p>
</div>

<div class="card p-6 max-w-3xl">
    <form action="<?= base_url('admin/educations/store') ?>" method="post" enctype="multipart/form-data" class="space-y-6">
        <?= csrf_field() ?>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Nama Institusi *</label>
            <input type="text" name="institution" value="<?= old('institution') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Universitas Indonesia" required>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Jenjang *</label>
            <select name="degree" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" required>
                <option value="">Pilih Jenjang</option>
                <option value="SD" <?= old('degree') === 'SD' ? 'selected' : '' ?>>SD</option>
                <option value="SMP" <?= old('degree') === 'SMP' ? 'selected' : '' ?>>SMP</option>
                <option value="SMA" <?= old('degree') === 'SMA' ? 'selected' : '' ?>>SMA</option>
                <option value="SMK" <?= old('degree') === 'SMK' ? 'selected' : '' ?>>SMK</option>
                <option value="D3" <?= old('degree') === 'D3' ? 'selected' : '' ?>>D3</option>
                <option value="S1" <?= old('degree') === 'S1' ? 'selected' : '' ?>>S1</option>
                <option value="S2" <?= old('degree') === 'S2' ? 'selected' : '' ?>>S2</option>
                <option value="S3" <?= old('degree') === 'S3' ? 'selected' : '' ?>>S3</option>
            </select>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Jurusan / Program Studi</label>
            <input type="text" name="major" value="<?= old('major') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Teknik Informatika">
        </div>
        
        <div class="grid md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-slate-200 mb-2">Tahun Mulai</label>
                <input type="number" name="start_year" value="<?= old('start_year') ?>" min="1950" max="2100" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="2018">
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-200 mb-2">Tahun Selesai</label>
                <input type="number" name="end_year" value="<?= old('end_year') ?>" min="1950" max="2100" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Kosongkan jika masih berlangsung">
            </div>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Lokasi</label>
            <input type="text" name="location" value="<?= old('location') ?>" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none transition-all" placeholder="Jakarta, Indonesia">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Deskripsi</label>
            <textarea name="description" rows="4" class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-dark-300/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/30 outline-none resize-none transition-all" placeholder="Ceritakan pengalaman belajar Anda..."><?= old('description') ?></textarea>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-slate-200 mb-2">Logo Institusi</label>
            <input type="file" name="logo" accept="image/*" class="text-sm text-slate-300 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary/20 file:text-primary hover:file:bg-primary/30 file:transition-colors file:cursor-pointer cursor-pointer">
        </div>
        
        <div class="flex justify-end gap-3 pt-6 border-t border-slate-700/50">
            <a href="<?= base_url('admin/educations') ?>" class="px-6 py-3 rounded-xl bg-slate-700 text-slate-200 hover:bg-slate-600 transition-all font-medium">Batal</a>
            <button type="submit" class="px-6 py-3 rounded-xl bg-gradient-to-r from-primary to-purple-600 text-white font-medium hover:shadow-lg hover:shadow-primary/30 transition-all flex items-center gap-2">
                <i data-lucide="save" class="w-5 h-5"></i>
                Simpan
            </button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>
